/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.codedeploy;

import com.atlassian.bamboo.credentials.CredentialsAccessor;
import com.atlassian.bamboo.credentials.CredentialsData;
import com.atlassian.bamboo.plugins.aws.codedeploy.CodeDeployTaskConfigurator;
import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.task.AnyTask;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.model.task.AnyTaskProperties;
import com.atlassian.bamboo.specs.api.model.task.TaskProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.task.TaskContainer;
import com.atlassian.bamboo.task.TaskDefinition;
import com.atlassian.bamboo.task.export.TaskDefinitionExporter;
import com.atlassian.bamboo.task.export.TaskValidationContext;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class CodeDeployTaskExporter
implements TaskDefinitionExporter {
    private static final Logger log = Logger.getLogger(CodeDeployTaskExporter.class);
    @Autowired
    private CredentialsAccessor credentialsAccessor;
    public static final Set<String> FIELD_KEYS = ImmutableSet.builder().add((Object)CodeDeployTaskConfigurator.CFG_REGION).add((Object)CodeDeployTaskConfigurator.CFG_APPLICATION_NAME).add((Object)CodeDeployTaskConfigurator.CFG_S3_BUCKET).add((Object)CodeDeployTaskConfigurator.CFG_DEPLOYMENT_GROUP).add((Object)"workingSubDirectory").build();

    private Object getCredentialRef(@NotNull Map<String, String> configuration) {
        String credentialKey = configuration.get(CodeDeployTaskConfigurator.CFG_CREDENTIALS_ID);
        CredentialsData credentials = this.credentialsAccessor.getCredentials(Long.parseLong(credentialKey));
        if (credentials != null) {
            return credentials.getOid().getValue();
        }
        return "unknownCredentials";
    }

    @NotNull
    public Map<String, String> toTaskConfiguration(@NotNull TaskContainer taskContainer, @NotNull TaskProperties taskProperties) {
        return ((AnyTaskProperties)taskProperties).getConfiguration();
    }

    @NotNull
    public Task toSpecsEntity(@NotNull TaskDefinition taskDefinition) {
        return new AnyTask(new AtlassianModule(taskDefinition.getPluginKey())).configuration(taskDefinition.getConfiguration());
    }

    public List<ValidationProblem> validate(@NotNull TaskValidationContext taskValidationContext, @NotNull TaskProperties taskProperties) {
        return Collections.emptyList();
    }
}

