/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugins.aws.codedeploy;

import com.atlassian.bamboo.configuration.ConfigurationMap;
import com.atlassian.bamboo.plugins.aws.codedeploy.CodeDeployTaskConfigurator;
import com.atlassian.bamboo.plugins.aws.core.AwsRegion;
import com.atlassian.bamboo.task.CommonTaskContext;
import org.jetbrains.annotations.NotNull;

public class CodeDeployConfig {
    private final long credentialsId;
    private final AwsRegion region;
    private final String applicationName;
    private final String s3Bucket;
    private final String deploymentGroup;

    @NotNull
    public static CodeDeployConfig fromContext(@NotNull CommonTaskContext taskContext) {
        return new CodeDeployConfig(taskContext.getConfigurationMap());
    }

    private CodeDeployConfig(@NotNull ConfigurationMap configurationMap) {
        this.credentialsId = configurationMap.getAsLong(CodeDeployTaskConfigurator.CFG_CREDENTIALS_ID);
        this.region = AwsRegion.valueOf((String)((String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_REGION)));
        this.applicationName = (String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_APPLICATION_NAME);
        this.s3Bucket = (String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_S3_BUCKET);
        this.deploymentGroup = (String)configurationMap.get((Object)CodeDeployTaskConfigurator.CFG_DEPLOYMENT_GROUP);
    }

    public long getCredentialsId() {
        return this.credentialsId;
    }

    public AwsRegion getRegion() {
        return this.region;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getS3Bucket() {
        return this.s3Bucket;
    }

    public String getDeploymentGroup() {
        return this.deploymentGroup;
    }
}

