/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators.plan;

import com.atlassian.bamboo.specs.api.model.plan.JobProperties;
import com.atlassian.bamboo.specs.api.model.plan.artifact.ArtifactSubscriptionProperties;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class JobValidator {
    private JobValidator() {
    }

    @NotNull
    public static List<ValidationProblem> validate(@NotNull JobProperties jobProperties) {
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        errors.addAll(JobValidator.validateUniqueSubscriptions(jobProperties.getArtifactSubscriptions()));
        return errors;
    }

    private static Collection<? extends ValidationProblem> validateUniqueSubscriptions(List<ArtifactSubscriptionProperties> artifactSubscriptions) {
        HashSet<ArtifactSubscriptionProperties> artifactSubscriptionSet = new HashSet<ArtifactSubscriptionProperties>();
        ArrayList<ValidationProblem> errors = new ArrayList<ValidationProblem>();
        for (ArtifactSubscriptionProperties artifactSubscription : artifactSubscriptions) {
            if (artifactSubscriptionSet.contains(artifactSubscription)) {
                errors.add(new ValidationProblem(String.format("Duplicate artifact subscription of artifact [%s] to destination [%s]", artifactSubscription.getArtifactName(), artifactSubscription.getDestination())));
            }
            artifactSubscriptionSet.add(artifactSubscription);
        }
        return errors;
    }
}

