/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.validators;

import com.atlassian.bamboo.specs.api.validators.common.BambooStringUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import com.atlassian.bamboo.specs.api.validators.common.ValidationProblem;
import com.atlassian.bamboo.specs.api.validators.common.ValidationUtils;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LabelValidator {
    private static final char[] INVALID_LABEL_CHARACTERS = new char[]{':', ';', ',', '.', ' ', '\t', '\n', '\r', '\f', '?', '&', '[', ']', '(', ')', '#', '^', '*', '@', '!'};
    public static final char[] INVALID_CHARACTERS = ArrayUtils.addAll((char[])INVALID_LABEL_CHARACTERS, (char[])BambooStringUtils.XSS_RELATED_CHARACTERS);
    public static final String INVALID_CHARACTERS_FIND_EXPR = "[:;,\\.\\?&\\[\\]\\(\\)#\\^\\*@!\\s'\"\\\\<\\>]";

    private LabelValidator() {
    }

    public static Optional<ValidationProblem> validateLabel(@Nullable String label) {
        return LabelValidator.validateLabel(ValidationContext.empty(), label);
    }

    public static Optional<ValidationProblem> validateLabel(@NotNull ValidationContext validationContext, @Nullable String label) {
        return Optional.ofNullable(ValidationUtils.validateRequiredString(validationContext, label, true).orElseGet(() -> StringUtils.containsAny((CharSequence)label, (char[])INVALID_CHARACTERS) ? new ValidationProblem(validationContext.with("labels"), "Label %s contains invalid character: %s", label, LabelValidator.findFirstInvalidCharacter(label)) : null));
    }

    private static String findFirstInvalidCharacter(@Nullable String label) {
        int indexOfAny = StringUtils.indexOfAny((CharSequence)label, (char[])INVALID_CHARACTERS);
        return indexOfAny >= 0 ? StringUtils.substring((String)label, (int)indexOfAny, (int)(indexOfAny + 1)) : "";
    }
}

