/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.model.plan.configuration;

import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.plan.configuration.PluginConfigurationProperties;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import com.atlassian.bamboo.specs.api.validators.common.ValidationContext;
import java.util.Objects;

public class ConcurrentBuildsProperties
implements PluginConfigurationProperties {
    private boolean useSystemWideDefault = true;
    private int maximumNumberOfConcurrentBuilds = 1;
    private static final AtlassianModuleProperties ATLASSIAN_MODULE = new AtlassianModuleProperties("com.atlassian.bamboo.plugin.system.additionalBuildConfiguration:concurrentBuild");

    private ConcurrentBuildsProperties() {
    }

    public ConcurrentBuildsProperties(boolean useSystemWideDefault, int maximumNumberOfConcurrentBuilds) {
        this.useSystemWideDefault = useSystemWideDefault;
        this.maximumNumberOfConcurrentBuilds = maximumNumberOfConcurrentBuilds;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConcurrentBuildsProperties that = (ConcurrentBuildsProperties)o;
        return this.isUseSystemWideDefault() == that.isUseSystemWideDefault() && this.getMaximumNumberOfConcurrentBuilds() == that.getMaximumNumberOfConcurrentBuilds();
    }

    public int hashCode() {
        return Objects.hash(this.isUseSystemWideDefault(), this.getMaximumNumberOfConcurrentBuilds());
    }

    public boolean isUseSystemWideDefault() {
        return this.useSystemWideDefault;
    }

    public int getMaximumNumberOfConcurrentBuilds() {
        return this.maximumNumberOfConcurrentBuilds;
    }

    @Override
    public void validate() {
        ImporterUtils.checkThat(ValidationContext.of("maximumNumberOfConcurrentBuilds"), this.maximumNumberOfConcurrentBuilds > 0, "Maximum number of concurrent builds must be greater than 0.", new Object[0]);
    }

    @Override
    public AtlassianModuleProperties getAtlassianPlugin() {
        return ATLASSIAN_MODULE;
    }
}

