/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.task;

import com.atlassian.bamboo.specs.api.builders.AtlassianModule;
import com.atlassian.bamboo.specs.api.builders.task.Task;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.AtlassianModuleProperties;
import com.atlassian.bamboo.specs.api.model.task.AnyTaskProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class AnyTask
extends Task<AnyTask, AnyTaskProperties> {
    private final AtlassianModuleProperties atlassianPlugin;
    private Map<String, String> configuration = new LinkedHashMap<String, String>();

    public AnyTask(@NotNull AnyTask copy) {
        this.taskEnabled = copy.taskEnabled;
        this.description = copy.description;
        this.requirements = new ArrayList(copy.requirements);
        this.conditions = new ArrayList(copy.conditions);
        this.atlassianPlugin = copy.atlassianPlugin;
        this.configuration = new LinkedHashMap<String, String>(copy.configuration);
    }

    public AnyTask(@NotNull AtlassianModule atlassianPlugin) throws PropertiesValidationException {
        this.atlassianPlugin = (AtlassianModuleProperties)EntityPropertiesBuilders.build(atlassianPlugin);
    }

    public AnyTask configuration(Map<String, String> configuration) {
        this.configuration.putAll(configuration);
        return this;
    }

    @Override
    @NotNull
    protected AnyTaskProperties build() throws PropertiesValidationException {
        return new AnyTaskProperties(this.atlassianPlugin, this.description, this.taskEnabled, this.configuration, this.requirements, this.conditions);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnyTask)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AnyTask anyTask = (AnyTask)o;
        return Objects.equals(this.atlassianPlugin, anyTask.atlassianPlugin) && Objects.equals(this.configuration, anyTask.configuration);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.atlassianPlugin, this.configuration);
    }
}

