/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.specs.api.builders.plan;

import com.atlassian.bamboo.specs.api.builders.BambooKey;
import com.atlassian.bamboo.specs.api.builders.BambooOid;
import com.atlassian.bamboo.specs.api.builders.EntityPropertiesBuilder;
import com.atlassian.bamboo.specs.api.exceptions.PropertiesValidationException;
import com.atlassian.bamboo.specs.api.model.BambooKeyProperties;
import com.atlassian.bamboo.specs.api.model.BambooOidProperties;
import com.atlassian.bamboo.specs.api.model.plan.PlanIdentifierProperties;
import com.atlassian.bamboo.specs.api.util.EntityPropertiesBuilders;
import com.atlassian.bamboo.specs.api.validators.common.ImporterUtils;
import org.jetbrains.annotations.NotNull;

public class PlanIdentifier
extends EntityPropertiesBuilder<PlanIdentifierProperties> {
    private BambooKeyProperties projectKey;
    private BambooKeyProperties key;
    private BambooOidProperties oid;

    private PlanIdentifier() {
    }

    public PlanIdentifier(@NotNull String projectKey, @NotNull String planKey) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("projectKey", projectKey);
        ImporterUtils.checkNotBlank("key", planKey);
        this.key = new BambooKeyProperties(planKey);
        this.projectKey = new BambooKeyProperties(projectKey);
    }

    public PlanIdentifier(@NotNull BambooKey projectKey, @NotNull BambooKey planKey) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("projectKey", projectKey);
        ImporterUtils.checkNotNull("key", planKey);
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(planKey);
        this.projectKey = (BambooKeyProperties)EntityPropertiesBuilders.build(projectKey);
    }

    public PlanIdentifier(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
    }

    public PlanIdentifier oid(@NotNull String oid) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("oid", oid);
        return this.oid(new BambooOid(oid));
    }

    public PlanIdentifier oid(@NotNull BambooOid oid) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("oid", oid);
        this.oid = (BambooOidProperties)EntityPropertiesBuilders.build(oid);
        return this;
    }

    public PlanIdentifier key(@NotNull String key) throws PropertiesValidationException {
        ImporterUtils.checkNotBlank("key", key);
        return this.key(new BambooKey(key));
    }

    public PlanIdentifier key(@NotNull BambooKey key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        this.key = (BambooKeyProperties)EntityPropertiesBuilders.build(key);
        return this;
    }

    public PlanIdentifier projectKey(@NotNull String key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        return this.projectKey(new BambooKey(key));
    }

    public PlanIdentifier projectKey(@NotNull BambooKey key) throws PropertiesValidationException {
        ImporterUtils.checkNotNull("key", key);
        this.projectKey = (BambooKeyProperties)EntityPropertiesBuilders.build(key);
        return this;
    }

    @Override
    protected PlanIdentifierProperties build() throws PropertiesValidationException {
        return new PlanIdentifierProperties(this.projectKey, this.key, this.oid);
    }

    public BambooKey getProjectKey() {
        return this.projectKey == null ? null : new BambooKey(this.projectKey.getKey());
    }

    public BambooKey getPlanKey() {
        return this.key == null ? null : new BambooKey(this.key.getKey());
    }

    public BambooOid getPlanOid() {
        return this.oid == null ? null : new BambooOid(this.oid.getOid());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("PlanIdentifier{");
        sb.append("projectKey=").append(this.projectKey);
        sb.append(", key=").append(this.key);
        sb.append(", oid=").append(this.oid);
        sb.append('}');
        return sb.toString();
    }
}

