/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.scopedcaches;

import com.atlassian.bamboo.utils.scopedcaches.ThreadScopedCaches;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;

class ScopedCaches {
    private Map<ThreadScopedCaches.Key<?, ?>, Map<?, ?>> caches;
    private int scopeDepth = 0;

    ScopedCaches() {
    }

    void enterCachingScope() {
        ++this.scopeDepth;
    }

    int leaveCachingScope() {
        Preconditions.checkState((this.scopeDepth > 0 ? 1 : 0) != 0, (Object)"Not in caching scope, unable to leave");
        --this.scopeDepth;
        if (this.scopeDepth == 0) {
            this.caches = null;
        }
        return this.scopeDepth;
    }

    public boolean isInCachingScope() {
        return this.scopeDepth > 0;
    }

    public <K, V> Map<K, V> getCache(ThreadScopedCaches.Key<K, V> cacheKey) {
        Map cache = this.getCaches().computeIfAbsent(cacheKey, k -> new HashMap());
        return cache;
    }

    private Map<ThreadScopedCaches.Key<?, ?>, Map<?, ?>> getCaches() {
        if (this.caches == null) {
            this.caches = new HashMap();
        }
        return this.caches;
    }
}

