/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import com.atlassian.annotations.Internal;
import java.util.function.Supplier;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

@Internal
public class BambooLogger {
    private final Logger delegate;

    private BambooLogger(Logger delegate) {
        this.delegate = delegate;
    }

    public static BambooLogger getLogger(Class<?> clazz) {
        return new BambooLogger(Logger.getLogger(clazz));
    }

    public void fatal(String message) {
        this.delegate.fatal((Object)message);
    }

    public void fatal(String message, Throwable t) {
        this.delegate.fatal((Object)message, t);
    }

    public void fatal(String messageFormat, Object ... messageArgs) {
        if (this.delegate.isEnabledFor((Priority)Level.FATAL)) {
            this.delegate.fatal((Object)String.format(messageFormat, messageArgs));
        }
    }

    public void fatal(Supplier<String> messageSupplier) {
        if (this.delegate.isEnabledFor((Priority)Level.FATAL)) {
            this.delegate.fatal((Object)messageSupplier.get());
        }
    }

    public void error(String message) {
        this.delegate.error((Object)message);
    }

    public void error(String message, Throwable t) {
        this.delegate.error((Object)message, t);
    }

    public void error(String messageFormat, Object ... messageArgs) {
        if (this.delegate.isEnabledFor((Priority)Level.ERROR)) {
            this.delegate.error((Object)String.format(messageFormat, messageArgs));
        }
    }

    public void error(Supplier<String> messageSupplier) {
        if (this.delegate.isEnabledFor((Priority)Level.ERROR)) {
            this.delegate.error((Object)messageSupplier.get());
        }
    }

    public void warn(String message) {
        this.delegate.warn((Object)message);
    }

    public void warn(String message, Throwable t) {
        this.delegate.warn((Object)message, t);
    }

    public void warn(String messageFormat, Object ... messageArgs) {
        if (this.delegate.isEnabledFor((Priority)Level.WARN)) {
            this.delegate.warn((Object)String.format(messageFormat, messageArgs));
        }
    }

    public void warn(Supplier<String> messageSupplier) {
        if (this.delegate.isEnabledFor((Priority)Level.WARN)) {
            this.delegate.warn((Object)messageSupplier.get());
        }
    }

    public void info(String message) {
        this.delegate.info((Object)message);
    }

    public void info(String message, Throwable t) {
        this.delegate.info((Object)message, t);
    }

    public void info(String messageFormat, Object ... messageArgs) {
        if (this.delegate.isEnabledFor((Priority)Level.INFO)) {
            this.delegate.info((Object)String.format(messageFormat, messageArgs));
        }
    }

    public void info(Supplier<String> messageSupplier) {
        if (this.delegate.isEnabledFor((Priority)Level.INFO)) {
            this.delegate.info((Object)messageSupplier.get());
        }
    }

    public void debug(String message) {
        this.delegate.debug((Object)message);
    }

    public void debug(String message, Throwable t) {
        this.delegate.debug((Object)message, t);
    }

    public void debug(String messageFormat, Object ... messageArgs) {
        if (this.delegate.isEnabledFor((Priority)Level.DEBUG)) {
            this.delegate.debug((Object)String.format(messageFormat, messageArgs));
        }
    }

    public void debug(Supplier<String> messageSupplier) {
        if (this.delegate.isEnabledFor((Priority)Level.DEBUG)) {
            this.delegate.debug((Object)messageSupplier.get());
        }
    }

    public void trace(String message) {
        this.delegate.trace((Object)message);
    }

    public void trace(String message, Throwable t) {
        this.delegate.trace((Object)message, t);
    }

    public void trace(String messageFormat, Object ... messageArgs) {
        if (this.delegate.isEnabledFor((Priority)Level.TRACE)) {
            this.delegate.trace((Object)String.format(messageFormat, messageArgs));
        }
    }

    public void trace(Supplier<String> messageSupplier) {
        if (this.delegate.isEnabledFor((Priority)Level.TRACE)) {
            this.delegate.trace((Object)messageSupplier.get());
        }
    }
}

