/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.predicates.text;

import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TextPredicates {
    private static final Predicate<String> IGNORE_LINE_COMMENT = Pattern.compile("^#").asPredicate().negate();

    public static Predicate<String> ignoreLineComment() {
        return IGNORE_LINE_COMMENT;
    }

    public static Predicate<String> startsWith(@NotNull String prefix) {
        return input -> input.startsWith(prefix);
    }

    public static Predicate<String> startsWithAny(String ... prefixes) {
        return input -> StringUtils.startsWithAny((CharSequence)input, (CharSequence[])prefixes);
    }

    public static Predicate<String> endsWithAny(String ... endings) {
        return input -> Arrays.stream(endings).anyMatch(e -> StringUtils.endsWith((CharSequence)input, (CharSequence)e));
    }

    public static Predicate<String> endsWithAny(Iterable<String> endings) {
        return input -> StreamSupport.stream(endings.spliterator(), false).anyMatch(e -> StringUtils.endsWith((CharSequence)input, (CharSequence)e));
    }
}

