/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooReflectionUtils {
    @NotNull
    public static <T> T instantiateQuietly(@NotNull Class<T> aClass) {
        try {
            return aClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static Class<?> getSimpleType(@NotNull Class<?> aClass) {
        Class<?> simpleType = aClass;
        while (simpleType.getComponentType() != null) {
            simpleType = simpleType.getComponentType();
        }
        return simpleType;
    }

    public static List<Field> getAllDeclaredFields(@NotNull Class<?> clazz) {
        return BambooReflectionUtils.applyToAllClasses(clazz, Class::getDeclaredFields);
    }

    public static List<Method> getAllDeclaredMethods(Class<?> clazz) {
        return BambooReflectionUtils.applyToAllClasses(clazz, Class::getDeclaredMethods);
    }

    @NotNull
    private static <T> List<T> applyToAllClasses(@NotNull Class<?> clazz, Function<Class<?>, T[]> function) {
        ArrayList<T> allFields = new ArrayList<T>();
        Class<?> myClazz = clazz;
        do {
            allFields.addAll(Arrays.asList(function.apply(myClazz)));
        } while ((myClazz = myClazz.getSuperclass()) != null);
        return allFields;
    }

    public static boolean hasCustomDeserialisation(Class<?> clazz) {
        for (Class<?> testedClass = clazz; testedClass != null; testedClass = testedClass.getSuperclass()) {
            if (!BambooReflectionUtils.declaresCustomDeserialisation(testedClass)) continue;
            return true;
        }
        return false;
    }

    private static boolean declaresCustomDeserialisation(Class<?> clazz) {
        return BambooReflectionUtils.getDeclaredMethodQuietly(clazz, "readResolve", new Class[0]) != null || BambooReflectionUtils.getDeclaredMethodQuietly(clazz, "readExternal", ObjectInput.class) != null || BambooReflectionUtils.getDeclaredMethodQuietly(clazz, "readObjectNoData", new Class[0]) != null || BambooReflectionUtils.getDeclaredMethodQuietly(clazz, "readObject", ObjectInputStream.class) != null;
    }

    @Nullable
    private static Method getDeclaredMethodQuietly(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredMethod(name, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

