/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils;

import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class BambooPreconditions {
    private BambooPreconditions() {
    }

    @Contract(value="false, _, _, _ -> fail")
    public static <T extends Exception> void checkThat(boolean condition, @NotNull Function<String, T> exceptionSupplier, @NotNull String errorMessage, Object ... errorMessageArguments) throws T {
        if (!condition) {
            throw (Exception)exceptionSupplier.apply(String.format(errorMessage, errorMessageArguments));
        }
    }

    @Contract(value="false, _, _ -> fail")
    public static <T extends Exception> void checkThat(boolean condition, @NotNull Function<String, T> exceptionSupplier, @NotNull Supplier<String> errorMessageSupplier) throws T {
        if (!condition) {
            throw (Exception)exceptionSupplier.apply(errorMessageSupplier.get());
        }
    }

    @Contract(value="false, _ -> fail")
    public static <T extends Exception> void checkThat(boolean condition, @NotNull Supplier<T> exceptionSupplier) throws T {
        if (!condition) {
            throw (Exception)exceptionSupplier.get();
        }
    }
}

