/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments.expiry;

import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryConfig;
import com.atlassian.bamboo.deployments.expiry.DeploymentExpiryType;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.joda.time.Period;

public class DeploymentExpiryConfigBuilder {
    private static final Logger log = Logger.getLogger(DeploymentExpiryConfigBuilder.class);
    private boolean expiryEnabled;
    private Set<DeploymentExpiryType> expiryTypes = new HashSet<DeploymentExpiryType>();
    private Period expiryPeriod;
    private int deploymentsToKeep = 2;
    private long maxIgnoredLogSize = -1L;
    private int anyDeploymentsToKeep;

    public DeploymentExpiryConfigBuilder() {
    }

    public DeploymentExpiryConfigBuilder(@NotNull DeploymentExpiryConfig deploymentExpiryConfig) {
        this.expiryEnabled = deploymentExpiryConfig.isExpiryEnabled();
        this.expiryTypes = Sets.newHashSet((Iterable)deploymentExpiryConfig.getExpiryTypes());
        this.expiryPeriod = deploymentExpiryConfig.getExpiryPeriod();
        this.deploymentsToKeep = deploymentExpiryConfig.getDeploymentsToKeep();
        this.anyDeploymentsToKeep = deploymentExpiryConfig.getAnyDeploymentsToKeep();
        this.maxIgnoredLogSize = deploymentExpiryConfig.getMaxIgnoredLogSize();
    }

    public DeploymentExpiryConfigBuilder withExpiryEnabled() {
        this.expiryEnabled = true;
        return this;
    }

    public DeploymentExpiryConfigBuilder withExpiryDisabled() {
        this.expiryEnabled = false;
        return this;
    }

    public DeploymentExpiryConfigBuilder withExpiryType(DeploymentExpiryType expiryType) {
        this.expiryTypes.add(expiryType);
        return this;
    }

    public DeploymentExpiryConfigBuilder withExpiryTypes(@NotNull Iterable<DeploymentExpiryType> expiryTypes) {
        Iterables.addAll(this.expiryTypes, expiryTypes);
        return this;
    }

    public DeploymentExpiryConfigBuilder withNoExpiryTypes() {
        this.expiryTypes.clear();
        return this;
    }

    public DeploymentExpiryConfigBuilder withExpiryPeriod(@NotNull Period expiryPeriod) {
        this.expiryPeriod = expiryPeriod;
        return this;
    }

    public DeploymentExpiryConfigBuilder withDeploymentsToKeep(int deploymentsToKeep) {
        this.deploymentsToKeep = deploymentsToKeep;
        return this;
    }

    public DeploymentExpiryConfigBuilder withAnyDeploymentsToKeep(int deploymentsToKeep) {
        this.anyDeploymentsToKeep = deploymentsToKeep;
        return this;
    }

    public DeploymentExpiryConfigBuilder withMaxIgnoredLogSize(long maxIgnoredLogSize) {
        this.maxIgnoredLogSize = maxIgnoredLogSize;
        return this;
    }

    @NotNull
    public DeploymentExpiryConfig build() {
        return new DeploymentExpiryConfig(this.expiryEnabled, this.expiryTypes, this.expiryPeriod, this.deploymentsToKeep, this.anyDeploymentsToKeep, this.maxIgnoredLogSize);
    }
}

