/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.deployments;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.deployments.DeploymentKey;
import com.atlassian.bamboo.deployments.DeploymentKeyImpl;
import com.atlassian.bamboo.deployments.DeploymentResultKey;
import com.atlassian.bamboo.deployments.environments.InternalEnvironment;
import com.atlassian.bamboo.deployments.results.InternalDeploymentResult;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

@Immutable
public class DeploymentResultKeyImpl
implements DeploymentResultKey {
    private static final char SEPARATOR_CHAR = '-';
    private final DeploymentKey environmentKey;
    private final long deploymentResultId;
    @Deprecated
    public static Function<String, DeploymentResultKey> FROM_STRING = new Function<String, DeploymentResultKey>(){

        public DeploymentResultKey apply(String input) {
            return DeploymentResultKeyImpl.from(input);
        }
    };

    private DeploymentResultKeyImpl(DeploymentKey environmentKey, long deploymentResultId) {
        this.environmentKey = environmentKey;
        this.deploymentResultId = deploymentResultId;
    }

    @NotNull
    public String getKey() {
        return String.format("%s-%d", this.environmentKey.getKey(), this.deploymentResultId);
    }

    @NotNull
    public Key getEntityKey() {
        return this.environmentKey;
    }

    public int getResultNumber() {
        return Math.toIntExact(this.deploymentResultId);
    }

    public long getResultNumberLong() {
        return this.deploymentResultId;
    }

    @Override
    public long getDeploymentResultId() {
        return this.deploymentResultId;
    }

    public static DeploymentResultKeyImpl from(@NotNull DeploymentKey environmentKey, long deploymentResultId) {
        return new DeploymentResultKeyImpl(environmentKey, deploymentResultId);
    }

    public static DeploymentResultKeyImpl from(@NotNull InternalEnvironment environment, @NotNull InternalDeploymentResult deploymentResult) {
        return new DeploymentResultKeyImpl(environment.getKey(), deploymentResult.getId());
    }

    public static DeploymentResultKeyImpl from(@NotNull String key) {
        Object[] split = StringUtils.split((String)key, (char)'-');
        Preconditions.checkArgument((split.length > 1 ? 1 : 0) != 0);
        String deploymentKeyStr = StringUtils.join((Object[])split, (char)'-', (int)0, (int)(split.length - 1));
        DeploymentKeyImpl environmentKey = new DeploymentKeyImpl(deploymentKeyStr);
        return DeploymentResultKeyImpl.from(environmentKey, Long.parseLong((String)split[split.length - 1]));
    }

    public String toString() {
        return this.getKey();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeploymentResultKey)) {
            return false;
        }
        DeploymentResultKey resultKey = (DeploymentResultKey)o;
        return this.deploymentResultId == resultKey.getDeploymentResultId() && Objects.equal((Object)this.environmentKey, (Object)resultKey.getEntityKey());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.environmentKey, this.deploymentResultId});
    }
}

