/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.v2.build.queue;

import com.atlassian.bamboo.Key;
import com.atlassian.bamboo.ResultKey;
import com.atlassian.bamboo.core.ResultKeyProvider;
import com.atlassian.bamboo.util.BambooIterables;
import com.atlassian.bamboo.v2.build.queue.BuildQueueManager;
import com.google.common.base.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class QueueManagerUtils {
    private static final Logger log = Logger.getLogger(QueueManagerUtils.class);
    public static final Function<ResultKeyProvider, ResultKey> GET_RESULT_KEY = input -> input.getResultKey();

    private QueueManagerUtils() {
    }

    public static void removeFromQueue(@NotNull BuildQueueManager buildQueueManager, @NotNull Key planKey) {
        log.info((Object)("Attempting to remove plan from queue: " + planKey));
        for (ResultKey resultKey : QueueManagerUtils.getQueuedExecutables(buildQueueManager)) {
            if (!resultKey.getEntityKey().equals(planKey)) continue;
            buildQueueManager.removeBuildFromQueue(resultKey);
        }
    }

    public static Iterable<ResultKey> getQueuedExecutables(BuildQueueManager buildQueueManager) {
        return BambooIterables.stream(buildQueueManager.getQueuedExecutables()).map(arg_0 -> GET_RESULT_KEY.apply(arg_0)).collect(Collectors.toList());
    }

    public static BuildQueueManager.QueuedResultKey asQueued(ResultKey resultKey) {
        return new BuildQueueManager.QueuedResultKey(resultKey, System.nanoTime());
    }

    public static Predicate<? super ResultKeyProvider> hasResultKeyEqualTo(ResultKey resultKey) {
        return input -> input.getResultKey().equals(resultKey);
    }
}

