/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.bamboo.util.DoubleThrowingPredicate;
import com.atlassian.bamboo.util.ThrowingPredicate;
import com.atlassian.bamboo.utils.Pair;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BambooIterables {
    private BambooIterables() {
    }

    @Nullable
    public static <T, E extends Throwable> T find(Iterable<T> iterable, ThrowingPredicate<? super T, E> predicate, @Nullable T defaultValue) throws E {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }

    @Nullable
    public static <T, E extends Throwable, F extends Throwable> T find(Iterable<T> iterable, DoubleThrowingPredicate<? super T, E, F> predicate, @Nullable T defaultValue) throws E, F {
        for (T element : iterable) {
            if (!predicate.apply(element)) continue;
            return element;
        }
        return defaultValue;
    }

    public static <T> boolean none(@NotNull Iterable<T> iterable, @NotNull Predicate<? super T> predicate) {
        return !Iterables.any(iterable, predicate);
    }

    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate, @Nullable String exceptionMessage) {
        try {
            return (T)Iterables.find(iterable, predicate);
        }
        catch (NoSuchElementException e) {
            throw new NoSuchElementException(exceptionMessage);
        }
    }

    public static <T> Iterable<T> concat(Iterable<? extends T> iterable, T object) {
        return Iterables.concat(iterable, Collections.singletonList(object));
    }

    public static <T> Iterable<T> concat(T object, Iterable<? extends T> iterable) {
        return Iterables.concat(Collections.singletonList(object), iterable);
    }

    @Deprecated
    public static <T> Pair<Iterable<T>, Iterable<T>> split(List<T> unfiltered, Predicate<T> predicate) {
        return Pair.make(Iterables.filter(unfiltered, predicate), Iterables.filter(unfiltered, (Predicate)Predicates.not(predicate)));
    }

    @Deprecated
    public static <T> Pair<Iterable<T>, Iterable<T>> split(Iterable<T> unfiltered, Predicate<T> predicate) {
        return Pair.make(Iterables.filter(unfiltered, predicate), Iterables.filter(unfiltered, (Predicate)Predicates.not(predicate)));
    }

    @Nullable
    public static <T> T removeFirst(@NotNull Iterable<T> iterable, @NotNull Predicate<T> predicate) {
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            T object = iterator.next();
            if (!predicate.apply(object)) continue;
            iterator.remove();
            return object;
        }
        return null;
    }

    public static boolean hasSize(@NotNull Iterable<?> iterable, int size) {
        Iterator<?> iterator = iterable.iterator();
        int numSkipped = Iterators.advance(iterator, (int)size);
        return numSkipped == size && !iterator.hasNext();
    }

    public static <T> Stream<T> stream(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false);
    }

    @NotNull
    public static <T> T getFirst(@NotNull Iterable<? extends T> iterable) {
        return iterable.iterator().next();
    }

    public static <T> Iterable<T> iterable(Supplier<Iterator<T>> supplier) {
        return supplier::get;
    }

    public static <T> boolean removeAll(@NotNull Iterable<T> iterable, @Nullable T o) {
        boolean modified = false;
        Iterator<T> it = iterable.iterator();
        while (it.hasNext()) {
            if (!Objects.equals(it.next(), o)) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }
}

