/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.builder;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum LifeCycleState {
    PENDING("Pending"),
    QUEUED("Queued"),
    IN_PROGRESS("InProgress"),
    FINISHED("Finished"),
    NOT_BUILT("NotBuilt");

    public static final EnumSet<LifeCycleState> ACTIVE_STATES;
    public static final EnumSet<LifeCycleState> FINAL_STATES;
    private final String state;
    private static final Map<String, LifeCycleState> LIFE_CYCLE_STATE_MAPPING;

    private LifeCycleState(String state) {
        this.state = state;
    }

    public static LifeCycleState getInstance(String state) {
        LifeCycleState lifeCycleState = LIFE_CYCLE_STATE_MAPPING.get(state);
        Preconditions.checkArgument((lifeCycleState != null ? 1 : 0) != 0, (Object)("There is no LifeCycleState called '" + state + "'"));
        return lifeCycleState;
    }

    @NotNull
    public String getValue() {
        return this.state;
    }

    public String toString() {
        return this.state;
    }

    public static boolean isPending(@Nullable LifeCycleState lifeCycleState) {
        return lifeCycleState == PENDING;
    }

    public static boolean isQueued(@Nullable LifeCycleState lifeCycleState) {
        return lifeCycleState == QUEUED;
    }

    public static boolean isWaiting(@Nullable LifeCycleState lifeCycleState) {
        return LifeCycleState.isPending(lifeCycleState) || LifeCycleState.isQueued(lifeCycleState);
    }

    public static boolean isActive(@Nullable LifeCycleState lifeCycleState) {
        return ACTIVE_STATES.contains((Object)lifeCycleState);
    }

    public static boolean isFinalized(@Nullable LifeCycleState lifeCycleState) {
        return FINAL_STATES.contains((Object)lifeCycleState);
    }

    public static boolean isInProgress(@Nullable LifeCycleState lifeCycleState) {
        return lifeCycleState == IN_PROGRESS;
    }

    public static boolean isFinished(@Nullable LifeCycleState lifeCycleState) {
        return lifeCycleState == FINISHED;
    }

    public static boolean isNotBuilt(@Nullable LifeCycleState lifeCycleState) {
        return lifeCycleState == NOT_BUILT;
    }

    public static Collection<String> lifeCycleStatesToStringCollection(@NotNull Collection<LifeCycleState> lifeCycleStates) {
        return lifeCycleStates.stream().map(LifeCycleState::getValue).collect(Collectors.toList());
    }

    public static boolean isExpectedStateTransition(@Nullable LifeCycleState oldState, @NotNull LifeCycleState newState) {
        return oldState == null || oldState.ordinal() < FINISHED.ordinal() && newState.ordinal() > oldState.ordinal();
    }

    static {
        ACTIVE_STATES = EnumSet.of(PENDING, QUEUED, IN_PROGRESS);
        FINAL_STATES = EnumSet.of(FINISHED, NOT_BUILT);
        LIFE_CYCLE_STATE_MAPPING = new HashMap<String, LifeCycleState>(){
            {
                for (LifeCycleState lifeCycleState : LifeCycleState.values()) {
                    this.put(lifeCycleState.state, lifeCycleState);
                }
            }
        };
    }
}

