/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.applinks;

import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ReturningResponseHandler;
import io.atlassian.fugue.Either;
import org.apache.log4j.Logger;

public class ApplicationLinkRequestUtils {
    private static final Logger log = Logger.getLogger(ApplicationLinkRequestUtils.class);

    public static <T> T execute(ApplicationLinkRequestFactory requestFactory, ApplicationLinkRequest request, ReturningResponseHandler<Response, T> responseHandler) throws CredentialsRequiredException, ResponseException {
        Either either = (Either)request.execute(new CredentialsRequiredHandlerWrapper(responseHandler));
        if (either.isRight()) {
            return (T)either.right().get();
        }
        throw new CredentialsRequiredException((AuthorisationURIGenerator)requestFactory, "You do not have an authorized access token for the remote resource.");
    }

    private static class CredentialsRequired {
        private String statusMessage;

        private CredentialsRequired(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        private String getStatusMessage() {
            return this.statusMessage;
        }
    }

    private static class CredentialsRequiredHandlerWrapper<T>
    implements ApplicationLinkResponseHandler<Either<CredentialsRequired, T>> {
        private ReturningResponseHandler<Response, T> responseHandler;

        private CredentialsRequiredHandlerWrapper(ReturningResponseHandler<Response, T> responseHandler) {
            this.responseHandler = responseHandler;
        }

        public Either<CredentialsRequired, T> credentialsRequired(Response response) throws ResponseException {
            return Either.left((Object)new CredentialsRequired(response.getStatusText()));
        }

        public Either<CredentialsRequired, T> handle(Response response) throws ResponseException {
            return Either.right((Object)this.responseHandler.handle(response));
        }
    }
}

