/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plugin;

import com.atlassian.bamboo.plugin.OsgiServiceProxyFactory;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.event.events.PluginFrameworkShutdownEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.osgi.util.tracker.ServiceTracker;
import org.springframework.beans.factory.InitializingBean;

public class OsgiServiceProxyFactoryImpl
implements OsgiServiceProxyFactory,
InitializingBean {
    private static final Logger log = Logger.getLogger(OsgiServiceProxyFactoryImpl.class);
    private final long defaultTimeout;
    private final Cache<Class<?>, ServiceTracker> serviceTrackers;
    private final PluginEventManager pluginEventManager;

    public OsgiServiceProxyFactoryImpl(PluginEventManager pluginEventManager, final OsgiContainerManager osgiContainerManager, long defaultTimeout) {
        this(pluginEventManager, new ServiceTrackerFactory(){

            @Override
            public ServiceTracker create(String name) {
                return osgiContainerManager.getServiceTracker(name);
            }
        }, defaultTimeout);
    }

    public OsgiServiceProxyFactoryImpl(PluginEventManager pluginEventManager, final ServiceTrackerFactory serviceTrackerFactory, long defaultTimeout) {
        this.pluginEventManager = pluginEventManager;
        this.defaultTimeout = defaultTimeout;
        this.serviceTrackers = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<Class, ServiceTracker>(){

            public ServiceTracker load(Class key) {
                return serviceTrackerFactory.create(key.getName());
            }
        });
    }

    @Override
    public <T> T createProxy(Class<T> apiClass, long timeoutInMillis) {
        return (T)Proxy.newProxyInstance(apiClass.getClassLoader(), new Class[]{apiClass}, (InvocationHandler)new DynamicServiceInvocationHandler(this.serviceTrackers, apiClass, timeoutInMillis));
    }

    @Override
    public <T> T createProxy(Class<T> apiClass) {
        return this.createProxy(apiClass, this.defaultTimeout);
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginEventManager.register((Object)this);
    }

    @PluginEventListener
    public void onPluginFrameworkShutdownEvent(@NotNull PluginFrameworkShutdownEvent event) {
        this.serviceTrackers.invalidateAll();
    }

    static class DynamicServiceInvocationHandler
    implements InvocationHandler {
        private final Cache<Class<?>, ServiceTracker> serviceTrackers;
        private final Class<?> clazz;
        private final long timeoutInMillis;

        DynamicServiceInvocationHandler(Cache<Class<?>, ServiceTracker> serviceTrackers, Class<?> clazz, long timeoutInMillis) {
            this.serviceTrackers = serviceTrackers;
            this.clazz = clazz;
            this.timeoutInMillis = timeoutInMillis;
        }

        @Override
        public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
            if (Object.class == method.getDeclaringClass()) {
                try {
                    return method.invoke((Object)this, objects);
                }
                catch (InvocationTargetException e) {
                    throw e.getTargetException();
                }
            }
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Object service = ((ServiceTracker)this.serviceTrackers.get(this.clazz)).waitForService(this.timeoutInMillis);
                if (service == null) {
                    throw new ServiceTimeoutExceeded("Timeout exceeded waiting for service - " + this.clazz.getName());
                }
                Thread.currentThread().setContextClassLoader(service.getClass().getClassLoader());
                Object object = method.invoke(service, objects);
                return object;
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
        }

        public String toString() {
            return "OSGi Service:" + this.clazz.getName();
        }
    }

    public static class ServiceTimeoutExceeded
    extends RuntimeException {
        private static final long serialVersionUID = -5140347192225812816L;

        public ServiceTimeoutExceeded(String message) {
            super(message);
        }
    }

    public static interface ServiceTrackerFactory {
        public ServiceTracker create(String var1);
    }
}

