/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.artifact;

import com.atlassian.bamboo.plan.artifact.ArtifactSubscriptionContext;
import com.google.common.base.Preconditions;
import java.io.File;

public class ArtifactRetrievalStatus {
    public static final ArtifactRetrievalStatus UNABLE = new ArtifactRetrievalStatus();
    private final File file;
    private boolean isSingleFile;

    private ArtifactRetrievalStatus() {
        this.file = null;
    }

    public ArtifactRetrievalStatus(File file, boolean isSingleFile) {
        this.file = file;
        this.isSingleFile = isSingleFile;
    }

    public static ArtifactRetrievalStatus singleFile(File file) {
        return new ArtifactRetrievalStatus(file, true);
    }

    public static ArtifactRetrievalStatus multipleFiles(File dir) {
        return new ArtifactRetrievalStatus(dir, false);
    }

    public boolean isRetrieved() {
        return this.file != null;
    }

    public boolean isSingleFile() {
        return this.isSingleFile;
    }

    public void setRetrievalInfo(ArtifactSubscriptionContext artifactSubscription) {
        Preconditions.checkState((boolean)this.isRetrieved(), (Object)"Artifact is not retrieved");
        artifactSubscription.setSingleFile(this.isSingleFile());
        artifactSubscription.setEffectiveDestinationPath(this.file.getAbsolutePath());
    }
}

