/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class FileHashDescriptor {
    private final long checksum;
    private final String filename;

    @Deprecated
    public FileHashDescriptor(String filename, String checksum) {
        this(filename, Long.parseLong(checksum, 16));
    }

    public FileHashDescriptor(String filename, long checksum) {
        this.filename = filename;
        this.checksum = checksum;
    }

    public static Set<FileHashDescriptor> getFileHashDescriptors(@NotNull Map<String, String> fileToCrcHashMap) {
        return Sets.newHashSet((Iterable)Collections2.transform(fileToCrcHashMap.entrySet(), (Function)new Function<Map.Entry<String, String>, FileHashDescriptor>(){

            public FileHashDescriptor apply(Map.Entry<String, String> input) {
                return new FileHashDescriptor(input.getKey(), Long.parseLong(input.getValue(), 16));
            }
        }));
    }

    public String getFilename() {
        return this.filename;
    }

    public long getChecksum() {
        return this.checksum;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FileHashDescriptor that = (FileHashDescriptor)o;
        if (this.checksum != that.checksum) {
            return false;
        }
        return this.filename.equals(that.filename);
    }

    public int hashCode() {
        int result = (int)(this.checksum ^ this.checksum >>> 32);
        result = 31 * result + this.filename.hashCode();
        return result;
    }

    public String toString() {
        return this.filename + '|' + Long.toHexString(this.checksum);
    }
}

