/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.map;

import com.google.common.base.Function;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.ListOrderedMap;
import org.apache.log4j.Logger;

public class NonThreadSafeComputingMap<K, V>
implements Map<K, V> {
    private static final Logger log = Logger.getLogger(NonThreadSafeComputingMap.class);
    private final Map<K, V> delegate;
    private final Function<K, V> computingFunction;

    public NonThreadSafeComputingMap(Function<K, V> computingFunction) {
        this((Map<K, V>)new ListOrderedMap(), computingFunction);
    }

    public NonThreadSafeComputingMap(Map<K, V> delegate, Function<K, V> computingFunction) {
        this.delegate = delegate;
        this.computingFunction = computingFunction;
    }

    @Override
    public V get(Object o) {
        Object key = o;
        if (!this.delegate.containsKey(key)) {
            this.delegate.put(key, this.computingFunction.apply(key));
        }
        return this.delegate.get(key);
    }

    @Override
    public boolean equals(Object o) {
        return ((Object)this.delegate).equals(o);
    }

    @Override
    public int hashCode() {
        return ((Object)this.delegate).hashCode();
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public V remove(Object key) {
        return this.delegate.remove(key);
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.delegate.containsValue(value);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate.values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet();
    }

    @Override
    public V put(K key, V value) {
        return this.delegate.put(key, value);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.delegate.putAll(m);
    }
}

