/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import org.jetbrains.annotations.Nullable;

public class BambooObjectUtils {
    private BambooObjectUtils() {
    }

    public static <T extends Comparable<T>> int compare(@Nullable T lhs, @Nullable T rhs) {
        if (lhs == null) {
            return rhs == null ? 0 : -1;
        }
        if (rhs == null) {
            return 1;
        }
        return lhs.compareTo(rhs);
    }

    @Nullable
    public static <T> T defaultObject(@Nullable T object, @Nullable T defaultVal) {
        return object != null ? object : defaultVal;
    }

    public static String getId(@Nullable Object o) {
        if (o != null) {
            return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
        }
        return null;
    }

    public static <T extends Throwable, C extends T> RuntimeException rethrow(T t, Class<C> toRethrowC) throws C {
        if (toRethrowC.isAssignableFrom(t.getClass())) {
            throw t;
        }
        return BambooObjectUtils.rethrowUnexpectedException(t);
    }

    public static <T extends Throwable, C extends T, D extends T> RuntimeException rethrow(T t, Class<C> toRethrowC, Class<D> toRethrowD) throws C, D {
        if (toRethrowC.isAssignableFrom(t.getClass())) {
            throw t;
        }
        if (toRethrowD.isAssignableFrom(t.getClass())) {
            throw t;
        }
        return BambooObjectUtils.rethrowUnexpectedException(t);
    }

    private static <T extends Throwable> RuntimeException rethrowUnexpectedException(T t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException("Unexpected exception", t);
    }
}

