/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.logger;

import com.atlassian.bamboo.buildqueue.manager.AgentManager;
import com.atlassian.bamboo.logger.ErrorDetails;
import com.atlassian.bamboo.logger.ThrowableDetails;
import com.atlassian.bamboo.plan.PlanManager;
import com.atlassian.bamboo.resultsummary.BuildResultsSummaryManager;
import java.util.Date;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import net.jcip.annotations.GuardedBy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class ElasticErrorDetails
extends ErrorDetails {
    private static final Logger log = Logger.getLogger(ElasticErrorDetails.class);
    @GuardedBy(value="this")
    private final List<String> instanceIds = new CopyOnWriteArrayList<String>();

    public ElasticErrorDetails(int errorNumber, @Nullable Long agentId, @Nullable String instanceId, String context, Date timeStamp, ThrowableDetails throwableDetails, PlanManager planManager, AgentManager agentManager, BuildResultsSummaryManager buildResultsSummaryManager) {
        super(errorNumber, "Elastic Bamboo", null, agentId, context, timeStamp, throwableDetails, planManager, agentManager, buildResultsSummaryManager);
        if (instanceId != null) {
            this.instanceIds.add(instanceId);
        }
    }

    public synchronized List<String> getInstanceIds() {
        return this.instanceIds;
    }

    public synchronized void addInstance(String instanceId) {
        if (instanceId != null) {
            this.instanceIds.add(instanceId);
        }
    }

    @Override
    public boolean isForAllBuilds() {
        return false;
    }

    @Override
    public boolean isBuildSpecific() {
        return false;
    }

    @Override
    public boolean isElastic() {
        return true;
    }
}

