/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.build.logger.interceptors;

import com.atlassian.bamboo.build.LogEntry;
import com.atlassian.bamboo.build.logger.LogInterceptor;
import org.apache.commons.collections.Buffer;
import org.apache.commons.collections.BufferUtils;
import org.apache.commons.collections.buffer.CircularFifoBuffer;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LogMemorisingInterceptor
implements LogInterceptor {
    private static final Logger log = Logger.getLogger(LogMemorisingInterceptor.class);
    private final Buffer logEntries;

    public LogMemorisingInterceptor(int linesToRemember) {
        this.logEntries = BufferUtils.synchronizedBuffer((Buffer)new CircularFifoBuffer(linesToRemember));
    }

    @Override
    public void intercept(@NotNull LogEntry logEntry) {
        this.logEntries.add((Object)logEntry);
    }

    @Override
    public void interceptError(@NotNull LogEntry logEntry) {
        this.logEntries.add((Object)logEntry);
    }

    @NotNull
    public Iterable<LogEntry> getLogEntries() {
        return this.logEntries;
    }
}

