/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.author;

import com.atlassian.bamboo.author.Author;
import com.atlassian.bamboo.author.AuthorData;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.DeltaState;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChangeAuthor
implements Author {
    private String name;
    private String linkedUserName;
    List<ResultsSummary> triggeredBuildResults = Lists.newArrayList();
    List<ResultsSummary> fixes;
    List<ResultsSummary> breakages;
    List<ResultsSummary> successfulBuilds;
    List<ResultsSummary> failedBuilds;
    boolean isInit;
    private static final String BSLASH = "%5C";

    public ChangeAuthor(@NotNull String name) {
        this.name = name;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    public void setName(@NotNull String name) {
        this.name = name;
    }

    @Override
    public String getNameForUrl() {
        String urlName = this.getName();
        urlName = urlName.replaceAll("\\\\", BSLASH);
        return urlName;
    }

    @Override
    @NotNull
    public String getFullName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ChangeAuthor)) {
            return false;
        }
        ChangeAuthor rhs = (ChangeAuthor)o;
        return new EqualsBuilder().append((Object)this.getName(), (Object)rhs.getName()).isEquals();
    }

    @Override
    public int compareTo(AuthorData otherAuthor) {
        return new CompareToBuilder().append((Object)this.getName(), (Object)otherAuthor.getName()).toComparison();
    }

    public int hashCode() {
        return new HashCodeBuilder(61, 53).append((Object)this.getName()).toHashCode();
    }

    public String toString() {
        return this.getName();
    }

    private void init() {
        if (!this.isInit) {
            this.fixes = Lists.newArrayList();
            this.breakages = Lists.newArrayList();
            this.successfulBuilds = Lists.newArrayList();
            this.failedBuilds = Lists.newArrayList();
            for (ResultsSummary triggeredBuildResult : this.triggeredBuildResults) {
                if (BuildState.FAILED == triggeredBuildResult.getBuildState()) {
                    this.failedBuilds.add(triggeredBuildResult);
                } else {
                    this.successfulBuilds.add(triggeredBuildResult);
                }
                if (DeltaState.BROKEN == triggeredBuildResult.getDeltaState()) {
                    this.breakages.add(triggeredBuildResult);
                    continue;
                }
                if (DeltaState.FIXED != triggeredBuildResult.getDeltaState()) continue;
                this.fixes.add(triggeredBuildResult);
            }
            this.isInit = true;
        }
    }

    @Override
    public List<ResultsSummary> getBreakages() {
        this.init();
        return this.breakages;
    }

    @Override
    public List<ResultsSummary> getFixes() {
        this.init();
        return this.fixes;
    }

    @Override
    public List<ResultsSummary> getFailedBuilds() {
        this.init();
        return this.failedBuilds;
    }

    @Override
    public List<ResultsSummary> getSuccessfulBuilds() {
        this.init();
        return this.successfulBuilds;
    }

    @Override
    public List<ResultsSummary> getTriggeredBuildResults() {
        return this.triggeredBuildResults;
    }

    @Override
    public List<ResultsSummary> getAllTriggeredBuildResults() {
        return this.getTriggeredBuildResults();
    }

    @Override
    public int getNumberOfBreakages() {
        this.init();
        return this.breakages.size();
    }

    @Override
    public int getNumberOfFixes() {
        this.init();
        return this.fixes.size();
    }

    @Override
    public int getNumberOfFailedBuilds() {
        this.init();
        return this.failedBuilds.size();
    }

    @Override
    public int getNumberOfSuccessfulBuilds() {
        this.init();
        return this.successfulBuilds.size();
    }

    @Override
    public int getNumberOfTriggeredBuilds() {
        return this.triggeredBuildResults.size();
    }

    @Override
    public String getLinkedUserName() {
        return this.linkedUserName;
    }

    @Override
    public void setLinkedUserName(@Nullable String linkedUserName) {
        this.linkedUserName = linkedUserName;
    }

    public void addTriggeredBuildResult(ResultsSummary resultsSummary) {
        this.triggeredBuildResults.add(resultsSummary);
        this.isInit = false;
    }
}

