/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.utils.error;

import com.atlassian.bamboo.utils.error.ErrorCollection;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;

public class SimpleErrorCollection
implements ErrorCollection {
    Map<String, String> errors = new HashMap<String, String>(2);
    List<String> errorMessages = new LinkedList<String>();

    public SimpleErrorCollection() {
    }

    public SimpleErrorCollection(String ... errors) {
        this();
        for (String error : errors) {
            this.addErrorMessage(error);
        }
    }

    @Override
    public void addError(String field, String message) {
        this.errors.put(field, message);
    }

    @Override
    public String addErrorMessage(String message) {
        this.errorMessages.add(message);
        return message;
    }

    @Override
    public Collection<String> getErrorMessages() {
        return this.errorMessages;
    }

    @Override
    public void setErrorMessages(Collection<String> errorMessages) {
        this.errorMessages = Lists.newArrayList(errorMessages);
    }

    @Override
    public Collection<String> getFlushedErrorMessages() {
        List<String> errors = this.errorMessages;
        this.errorMessages = Lists.newArrayList();
        return errors;
    }

    @Override
    public Map<String, String> getErrors() {
        return this.errors;
    }

    @Override
    public void addErrorCollection(@NotNull ErrorCollection errors) {
        this.addErrorMessages(errors.getErrorMessages());
        this.addErrors(errors.getErrors());
    }

    @Override
    public void addErrorMessages(Collection<String> incomingMessages) {
        if (incomingMessages != null) {
            this.errorMessages.addAll(incomingMessages);
        }
    }

    @Override
    public String addErrorMessage(String message, Exception e) {
        String newMessage = message + "\n" + ExceptionUtils.getFullStackTrace((Throwable)e);
        this.addErrorMessage(newMessage);
        return newMessage;
    }

    @Override
    public void addErrors(Map<String, ?> incomingErrors) {
        if (incomingErrors != null) {
            for (Map.Entry<String, ?> mapEntry : incomingErrors.entrySet()) {
                if (!(mapEntry.getValue() instanceof String)) continue;
                this.addError(mapEntry.getKey(), (String)mapEntry.getValue());
            }
        }
    }

    @Override
    public boolean hasAnyErrors() {
        return this.errors != null && !this.errors.isEmpty() || CollectionUtils.isNotEmpty(this.errorMessages);
    }

    @Override
    public Map<String, String> getFieldErrors() {
        return this.getErrors();
    }

    @Override
    public int getTotalErrors() {
        return this.getErrors().size() + this.getErrorMessages().size();
    }

    public String toString() {
        return "Errors: " + this.getErrors() + "\n" + "Error Messages: " + this.getErrorMessages();
    }

    @Override
    public void addError(String prefix, String field, String message) {
        this.errors.put(prefix + "." + field, message);
    }
}

