/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.opensymphony.util.TextUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HtmlUtils {
    private static final Logger log = Logger.getLogger(HtmlUtils.class);
    public static final String WBR = "&#8203;";
    public static final String BSLASH = "&#92;";
    private static final HtmlUtils instance = new HtmlUtils();

    private HtmlUtils() {
    }

    @NotNull
    public static String getAsPreformattedText(@Nullable Object o) {
        if (o == null) {
            return "";
        }
        String s = StringEscapeUtils.escapeHtml((String)o.toString());
        s = s.replaceAll("(\\n|\\r\\n)", "<br\\>$1");
        s = HtmlUtils.whiteSpacePreWrap(s);
        return s;
    }

    private static String whiteSpacePreWrap(String s) {
        s = s.replaceAll("  ", "&nbsp; ");
        s = s.replaceAll("  ", " &nbsp;");
        s = s.replaceAll("(\\t)", "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
        s = s.replaceAll("\\\\", BSLASH);
        return s;
    }

    public static String getTextAsHtml(Object o) {
        if (o == null) {
            return "";
        }
        String s = o instanceof String ? (String)o : o.toString();
        s = TextUtils.plainTextToHtml((String)s);
        s = HtmlUtils.whiteSpacePreWrap(s);
        return s;
    }

    public static String getFirstNLines(String s, int lines) {
        if (s == null) {
            return "";
        }
        s = StringUtils.replace((String)s, (String)"\r\n", (String)"\n");
        int numberOfLines = 0;
        int newlineChar = 0;
        int lastValidIndex = s.length();
        while (numberOfLines < lines && newlineChar != -1) {
            if ((newlineChar = StringUtils.indexOf((String)s, (String)"\n", (int)newlineChar)) == -1) continue;
            lastValidIndex = newlineChar++;
            ++numberOfLines;
        }
        if (numberOfLines < lines) {
            return s;
        }
        return s.substring(0, lastValidIndex);
    }

    public static String getFirstNLinesWithTrailer(String s, int lines) {
        int totalNumberOfLines = StringUtils.countMatches((String)s, (String)"\n");
        if (!s.endsWith("\n")) {
            ++totalNumberOfLines;
        }
        String showingLines = HtmlUtils.getFirstNLines(s, lines);
        if (totalNumberOfLines > lines) {
            int difference = totalNumberOfLines - lines;
            return showingLines + "\n(" + difference + " more lines...)";
        }
        return showingLines;
    }

    public static String getFirstNCharactersWithTrailer(@Nullable String s, int chars) {
        if (s == null || chars < 0) {
            return s;
        }
        if (s.length() <= chars) {
            return s;
        }
        String subString = s.substring(0, chars);
        return subString + "...";
    }

    public static String appendUrls(String url1, String url2) {
        if (url1.endsWith("/") && url2.startsWith("/")) {
            return url1 + url2.substring(1);
        }
        return url1 + url2;
    }

    public static String encodeUrl(String url) {
        String result;
        try {
            result = URLEncoder.encode(url, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException ex) {
            log.error((Object)"Url encoding operation is unsupported.");
            return url;
        }
        return result;
    }

    public static String addPrefixToLines(String prefix, String input) {
        return prefix + input.replaceAll("\n", "\n" + prefix);
    }

    public static HtmlUtils getInstanceForFreemarker() {
        return instance;
    }
}

