/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BambooProfilingUtils {
    private static final Logger log = Logger.getLogger(BambooProfilingUtils.class);

    private BambooProfilingUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T withUtilTimerStack(@NotNull String message, Callable<T> callable) throws Exception {
        UtilTimerStack.push((String)message);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            UtilTimerStack.pop((String)message);
        }
    }

    public static String getTimes(@NotNull Map<Object, Long> profiledCalls, int minimumDurationMs) {
        StringBuilder sb = new StringBuilder();
        sb.append("Total calls: " + profiledCalls.size() + "\n");
        sb.append("Accumulated times longer than " + minimumDurationMs + " ms:\n");
        BambooProfilingUtils.dumpAccumulatedTimes(sb, profiledCalls, minimumDurationMs);
        sb.append("\nIndividual times longer than " + minimumDurationMs + " ms:\n");
        BambooProfilingUtils.dumpSortedTimes(sb, profiledCalls, minimumDurationMs);
        return sb.toString();
    }

    private static void dumpAccumulatedTimes(@NotNull StringBuilder sb, @NotNull Map<Object, Long> profiledCalls, int longerThanMs) {
        HashMap profiledAccumulatedCalls = Maps.newHashMap();
        for (Map.Entry<Object, Long> profileEntry : profiledCalls.entrySet()) {
            String profiledObjectName = BambooProfilingUtils.genNameFromToString(profileEntry.getKey());
            Long oldValue = (Long)profiledAccumulatedCalls.get(profiledObjectName);
            if (oldValue == null) {
                oldValue = 0L;
            }
            profiledAccumulatedCalls.put(profiledObjectName, oldValue + profileEntry.getValue());
        }
        BambooProfilingUtils.dumpSortedTimes(sb, profiledAccumulatedCalls, longerThanMs);
    }

    private static void dumpSortedTimes(@NotNull StringBuilder sb, @NotNull Map<Object, Long> profiledCalls, int longerThanMs) {
        final long longerThanNs = TimeUnit.MILLISECONDS.toNanos(longerThanMs);
        Comparator<ProfileEntry> profileComparator = new Comparator<ProfileEntry>(){

            @Override
            public int compare(ProfileEntry o1, ProfileEntry o2) {
                return (int)(o2.getTime() - o1.getTime());
            }
        };
        Collection longCalls = Collections2.filter(profiledCalls.entrySet(), (Predicate)new Predicate<Map.Entry<Object, Long>>(){

            public boolean apply(Map.Entry<Object, Long> profileEntry) {
                return profileEntry.getValue() >= longerThanNs;
            }
        });
        List sortedProfiledEntries = Ordering.from((Comparator)profileComparator).sortedCopy((Iterable)Collections2.transform((Collection)longCalls, (Function)new Function<Map.Entry<Object, Long>, ProfileEntry>(){

            public ProfileEntry apply(Map.Entry<Object, Long> input) {
                return new ProfileEntry(input.getKey(), input.getValue());
            }
        }));
        for (ProfileEntry sortedProfiledEntry : sortedProfiledEntries) {
            sb.append(sortedProfiledEntry.toString()).append("\n");
        }
    }

    private static String genNameFromToString(@NotNull Object object) {
        String firstLine = StringUtils.substringBefore((String)StringUtils.substringBefore((String)object.toString(), (String)"\n"), (String)"\r");
        return StringUtils.substringBeforeLast((String)firstLine, (String)"@");
    }

    private static class ProfileEntry {
        private static final long DISPLAY_AS_MILLISECONDS = TimeUnit.MILLISECONDS.toNanos(2L);
        private static final long DISPLAY_AS_MICROSECONDS = TimeUnit.MICROSECONDS.toNanos(2L);
        private final Object object;
        private final Long time;

        public ProfileEntry(Object object, Long time) {
            this.object = object;
            this.time = time;
        }

        public Long getTime() {
            return this.time;
        }

        public String toString() {
            return this.getName() + " : " + this.getPrettyTime(this.time);
        }

        private String getName() {
            return BambooProfilingUtils.genNameFromToString(this.object);
        }

        private String getPrettyTime(long nanos) {
            if (nanos > DISPLAY_AS_MILLISECONDS) {
                return TimeUnit.NANOSECONDS.toMillis(nanos) + " ms";
            }
            if (nanos > DISPLAY_AS_MICROSECONDS) {
                return TimeUnit.NANOSECONDS.toMicros(nanos) + " MICROs";
            }
            return nanos + " NANOs";
        }
    }
}

