/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.security.trustedapplications;

import com.atlassian.security.auth.trustedapps.EncryptionProvider;
import java.security.Key;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import org.apache.commons.codec.binary.Base64;
import org.apache.log4j.Logger;

public class KeyUtils {
    private static final Logger log = Logger.getLogger(KeyUtils.class);

    public static KeyPair generateNewKeyPair(EncryptionProvider encryptionProvider) {
        try {
            return encryptionProvider.generateNewKeyPair();
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String encode(Key key) {
        return new String(Base64.encodeBase64((byte[])key.getEncoded()));
    }

    public static PrivateKey decodePrivateKey(EncryptionProvider encryptionProvider, String keyStr) {
        byte[] data = Base64.decodeBase64((byte[])keyStr.getBytes());
        try {
            return encryptionProvider.toPrivateKey(data);
        }
        catch (Exception e) {
            log.error((Object)e);
            return new InvalidPrivateKey(e);
        }
    }

    public static PublicKey decodePublicKey(EncryptionProvider encryptionProvider, String keyStr) {
        byte[] data = Base64.decodeBase64((byte[])keyStr.getBytes());
        try {
            return encryptionProvider.toPublicKey(data);
        }
        catch (Exception e) {
            log.error((Object)e);
            return new InvalidPublicKey(e);
        }
    }

    static class InvalidKey
    implements Key {
        private final Exception cause;

        public InvalidKey(Exception cause) {
            this.cause = cause;
        }

        @Override
        public String getAlgorithm() {
            return "";
        }

        @Override
        public String getFormat() {
            return "";
        }

        @Override
        public byte[] getEncoded() {
            return new byte[0];
        }

        public String toString() {
            return "Invalid Key: " + this.cause.toString();
        }

        public Exception getCause() {
            return this.cause;
        }
    }

    public static class InvalidPublicKey
    extends InvalidKey
    implements PublicKey {
        public InvalidPublicKey(Exception cause) {
            super(cause);
        }
    }

    public static class InvalidPrivateKey
    extends InvalidKey
    implements PrivateKey {
        public InvalidPrivateKey(Exception cause) {
            super(cause);
        }
    }
}

