/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan.branch;

import com.atlassian.bamboo.fieldvalue.OptionallyConvertibleFromConfig;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class BranchSpecificConfiguration
implements OptionallyConvertibleFromConfig {
    private static final Logger log = Logger.getLogger(BranchSpecificConfiguration.class);
    private static final String BRANCH_CLEANUP_DISABLED = "branchConfiguration.cleanup.disabled";
    private boolean isValid;
    private boolean branchCleanupDisabled;

    @Override
    public void populateFromConfig(@NotNull HierarchicalConfiguration config) {
        this.isValid = config.containsKey(BRANCH_CLEANUP_DISABLED);
        this.branchCleanupDisabled = config.getBoolean(BRANCH_CLEANUP_DISABLED, false);
    }

    @Override
    @NotNull
    public HierarchicalConfiguration toConfiguration() {
        HierarchicalConfiguration config = new HierarchicalConfiguration();
        config.setDelimiterParsingDisabled(true);
        config.addProperty(BRANCH_CLEANUP_DISABLED, (Object)this.branchCleanupDisabled);
        return config;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    public boolean isBranchCleanupDisabled() {
        return this.branchCleanupDisabled;
    }

    public void setBranchCleanupDisabled(boolean branchCleanupDisabled) {
        this.branchCleanupDisabled = branchCleanupDisabled;
    }
}

