/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.index;

import java.io.IOException;
import org.apache.log4j.Logger;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.HitCollector;
import org.apache.lucene.search.Searcher;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractDocumentHitCollector
extends HitCollector {
    private static final Logger log = Logger.getLogger(AbstractDocumentHitCollector.class);
    protected volatile Searcher searcher;

    public Searcher getSearcher() {
        return this.searcher;
    }

    public void setSearcher(Searcher searcher) {
        this.searcher = searcher;
    }

    public void collect(int docId, float score) {
        try {
            Document doc = this.getSearcher().doc(docId);
            if (doc != null) {
                this.collect(doc);
            }
        }
        catch (IOException e) {
            log.warn((Object)("Unable to get document with id " + docId), (Throwable)e);
        }
    }

    protected void collect(@NotNull Document document) {
    }
}

