/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.configuration;

import com.atlassian.bamboo.utils.JavaVirtualMachineDetector;
import java.io.File;
import java.io.FilenameFilter;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.log4j.Logger;

public class Jdk {
    private static final Logger log = Logger.getLogger(Jdk.class);
    public static final String CAPABILITY_JDK_TYPE = "jdk";
    public static final String CAPABILITY_JDK_PREFIX = "system.jdk";
    private final String label;
    private final String homeDirectory;

    private Jdk(String homeDirectory) {
        this.homeDirectory = homeDirectory;
        File javaHome = new File(homeDirectory);
        JavaVirtualMachineDetector detector = new JavaVirtualMachineDetector(SystemUtils.IS_OS_MAC_OSX);
        this.label = detector.detectExternalJdkVersion(javaHome);
    }

    public Jdk(String label, String homeDirectory) {
        this.label = label;
        this.homeDirectory = homeDirectory;
    }

    public boolean isValid() {
        try {
            String[] files = null;
            File testOriginalDataDir = new File(this.homeDirectory, "bin/");
            if (testOriginalDataDir.isDirectory()) {
                files = testOriginalDataDir.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File directory, String filename) {
                        return filename.equals("java") || filename.equals("java.exe");
                    }
                });
            }
            return files != null && files.length > 0 && this.isAJdk();
        }
        catch (Exception e) {
            log.info((Object)"Failed", (Throwable)e);
            return false;
        }
    }

    public boolean isAJdk() {
        JavaVirtualMachineDetector detector = new JavaVirtualMachineDetector(SystemUtils.IS_OS_MAC_OSX);
        File javaHome = new File(this.homeDirectory);
        return detector.containsToolsJar(javaHome) && detector.containsJavac(javaHome);
    }

    public String getUiSwitchName() {
        return "JDK";
    }

    public static Jdk discoverDefaultJdk() {
        Jdk jdk;
        String javaVersion = SystemUtils.JAVA_VERSION;
        String envJavaHome = System.getenv("JAVA_HOME");
        if (!StringUtils.isEmpty((String)envJavaHome)) {
            jdk = new Jdk(envJavaHome);
            if (jdk.getLabel() != null) {
                return jdk;
            }
            log.warn((Object)"Environment variable JAVA_HOME does not point to valid JDK");
        }
        if ((jdk = new Jdk(javaVersion, SystemUtils.JAVA_HOME)).isValid()) {
            return jdk;
        }
        jdk = new Jdk(javaVersion, SystemUtils.getJavaHome().getParent());
        if (jdk.isValid()) {
            return jdk;
        }
        javaVersion = javaVersion + " (JRE)";
        return new Jdk(javaVersion, SystemUtils.JAVA_HOME);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public String getLabel() {
        return this.label;
    }

    public String getHomeDirectory() {
        return this.homeDirectory;
    }
}

