/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.classserver;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.agent.classserver.FileHashDescriptor;
import com.atlassian.util.concurrent.LazyReference;
import com.google.common.base.Supplier;
import com.google.common.io.InputSupplier;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Adler32;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Internal
public class JarDescriptor {
    private static final Logger log = Logger.getLogger(JarDescriptor.class);
    private final String name;
    private final InputSupplier<InputStream> inputSupplier;
    private final Supplier<Long> checksum = new LazyReference<Long>(){
        private static final int STREAM_BUFFER_LENGTH = 1024;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Long create() throws Exception {
            InputStream data = JarDescriptor.this.getInputStream();
            try {
                Adler32 checksum = new Adler32();
                byte[] buffer = new byte[1024];
                int read = data.read(buffer, 0, 1024);
                while (read > -1) {
                    checksum.update(buffer, 0, read);
                    read = data.read(buffer, 0, 1024);
                }
                Long l = checksum.getValue();
                return l;
            }
            finally {
                IOUtils.closeQuietly((InputStream)data);
            }
        }
    };

    public JarDescriptor(String name, InputSupplier<InputStream> inputSupplier) {
        this.name = name;
        this.inputSupplier = inputSupplier;
    }

    @NotNull
    public String getName() {
        return this.name;
    }

    public long getChecksum() {
        return (Long)this.checksum.get();
    }

    @NotNull
    public InputStream getInputStream() throws IOException {
        return (InputStream)this.inputSupplier.getInput();
    }

    @NotNull
    public FileHashDescriptor getFileHashDescriptor() {
        return new FileHashDescriptor(this.getName(), Long.toHexString(this.getChecksum()));
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append(this.checksum.get()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof JarDescriptor)) {
            return false;
        }
        JarDescriptor rhs = (JarDescriptor)o;
        return new EqualsBuilder().append((Object)this.name, (Object)rhs.name).append(this.checksum.get(), rhs.checksum.get()).isEquals();
    }

    public String toString() {
        return this.name;
    }
}

