/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.util;

import com.google.common.base.Function;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.CharUtils;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BambooStringUtils {
    private static final Logger log = Logger.getLogger(BambooStringUtils.class);
    private static final Pattern INVALID_CHARACTERS_REGEX = Pattern.compile("[^-A-Za-z0-9_:.]");
    public static final char CHAR_NONE = '\u0000';
    public static final char CHAR_APOSTROPHE = '\'';
    public static final char CHAR_BACKSLASH = '\\';
    public static final char CHAR_DOUBLE_QUOTE = '\"';
    private static final char[] XSS_RELATED_CHARACTERS = new char[]{'\"', '&', '\'', '<', '>', '\\'};
    private static final Pattern hrefPattern = Pattern.compile("a +href *= *\"([\\w\\$\\-\\+\\(\\):/\\.!\\?#]*(&[a-zA-Z])*)*\" *");
    private static final Pattern htmlWhiteListPattern = Pattern.compile("(/?+ *(p|i|b|div) *)|(/ *a *)|( *br */?+)");
    private static final Function<String, String> STRIP_FULLY_ENCLOSING_QUOTES = new Function<String, String>(){
        final Pattern FULLY_ENCLOSED_IN_DOUBLE_QUOTES = Pattern.compile("\"(.*)\"");
        final Pattern FULLY_ENCLOSED_IN_SINGLE_QUOTES = Pattern.compile("'(.*)'");

        public String apply(@Nullable String input) {
            Matcher matcher = this.FULLY_ENCLOSED_IN_DOUBLE_QUOTES.matcher(input);
            if (matcher.matches()) {
                input = matcher.group(1);
            } else {
                matcher = this.FULLY_ENCLOSED_IN_SINGLE_QUOTES.matcher(input);
                if (matcher.matches()) {
                    input = matcher.group(1);
                }
            }
            return input;
        }
    };

    private BambooStringUtils() {
    }

    @NotNull
    public static String forceAlphaNumeric(@Nullable String str) {
        if (str == null) {
            return "";
        }
        char[] charArray = str.toCharArray();
        StringBuffer sBuf = new StringBuffer();
        for (char aChar : charArray) {
            if (!CharUtils.isAsciiAlphanumeric((char)aChar)) continue;
            sBuf.append(aChar);
        }
        return sBuf.toString();
    }

    public static boolean containsXssRelatedCharacters(@Nullable String string) {
        return string != null && StringUtils.containsAny((String)string, (char[])XSS_RELATED_CHARACTERS);
    }

    @NotNull
    public static String getFirstXssRelatedCharacter(@Nullable String string) {
        if (string == null) {
            return "";
        }
        int unsafeCharIndex = StringUtils.indexOfAny((String)string, (char[])XSS_RELATED_CHARACTERS);
        if (unsafeCharIndex == -1) {
            return "";
        }
        return string.substring(unsafeCharIndex, unsafeCharIndex + 1);
    }

    @NotNull
    public static String forceValidHtmlId(@NotNull String id) {
        return INVALID_CHARACTERS_REGEX.matcher(id).replaceAll("_");
    }

    public static String encodeHtmlWithTagWhiteList(String string) {
        StringTokenizer st = new StringTokenizer(string, "<>", true);
        StringBuilder sb = new StringBuilder();
        String tagContent = null;
        EncoderState state = EncoderState.START;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            switch (state) {
                case START: {
                    if (token.equals("<")) {
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml((String)token));
                    break;
                }
                case AFTER_LT: {
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                        break;
                    }
                    if (token.equals(">")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)">"));
                        state = EncoderState.START;
                        break;
                    }
                    tagContent = token;
                    state = EncoderState.AFTER_TAG_CONTENT;
                    break;
                }
                case AFTER_TAG_CONTENT: {
                    if (token.equals(">") && htmlWhiteListPattern.matcher(tagContent).matches()) {
                        sb.append("<").append(tagContent).append(">");
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals(">") && tagContent.startsWith("a ")) {
                        sb.append(BambooStringUtils.sanitizeLink(tagContent));
                        state = EncoderState.START;
                        break;
                    }
                    if (token.equals("<")) {
                        sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                        sb.append(StringEscapeUtils.escapeHtml((String)tagContent));
                        state = EncoderState.AFTER_LT;
                        break;
                    }
                    sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                    sb.append(StringEscapeUtils.escapeHtml((String)tagContent));
                    sb.append(StringEscapeUtils.escapeHtml((String)token));
                    state = EncoderState.START;
                }
            }
        }
        switch (state) {
            case START: {
                break;
            }
            case AFTER_LT: {
                sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                break;
            }
            case AFTER_TAG_CONTENT: {
                sb.append(StringEscapeUtils.escapeHtml((String)"<"));
                sb.append(StringEscapeUtils.escapeHtml(tagContent));
            }
        }
        return sb.toString();
    }

    public static Function<String, String> encodeHtmlWithTagWhiteListFunction() {
        return new Function<String, String>(){

            public String apply(String from) {
                return BambooStringUtils.encodeHtmlWithTagWhiteList(from);
            }
        };
    }

    @NotNull
    public static String unquote(@NotNull String quotedVarValue, boolean processBackslashes) {
        char[] unquoted = new char[quotedVarValue.length()];
        int ui = 0;
        char quotedBy = '\u0000';
        boolean backslash = false;
        for (int i = 0; i < quotedVarValue.length(); ++i) {
            char lookingAt = quotedVarValue.charAt(i);
            if (backslash) {
                unquoted[ui++] = lookingAt;
                backslash = false;
                continue;
            }
            if (quotedBy != '\'' && lookingAt == '\\' && processBackslashes) {
                backslash = true;
                continue;
            }
            if (quotedBy == '\u0000' && BambooStringUtils.in(lookingAt, '\"', '\'')) {
                quotedBy = lookingAt;
                continue;
            }
            if (lookingAt == quotedBy) {
                quotedBy = '\u0000';
                continue;
            }
            unquoted[ui++] = lookingAt;
        }
        return new String(unquoted, 0, ui);
    }

    private static boolean in(char needle, char ... haystack) {
        for (char c : haystack) {
            if (needle != c) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String remove(@NotNull String quotedVarValue, int index) {
        if (index == -1) {
            return quotedVarValue;
        }
        String firstPart = quotedVarValue.substring(0, index);
        if (index == quotedVarValue.length()) {
            return firstPart;
        }
        return firstPart + quotedVarValue.substring(index + 1);
    }

    @Nullable
    public static String truncateAndAddEllipsis(@Nullable String string, int maxLength) {
        if (string != null && string.length() > maxLength) {
            return StringUtils.left((String)string, (int)(maxLength - 1)) + '\u2026';
        }
        return string;
    }

    private static String sanitizeLink(String string) {
        if (hrefPattern.matcher(string).matches()) {
            return "<" + string + ">";
        }
        return StringEscapeUtils.escapeHtml((String)"<") + StringEscapeUtils.escapeHtml((String)string) + StringEscapeUtils.escapeHtml((String)">");
    }

    public static Function<String, String> stripFullyEnclosingQuotes() {
        return STRIP_FULLY_ENCLOSING_QUOTES;
    }

    static enum EncoderState {
        START,
        AFTER_LT,
        AFTER_TAG_CONTENT;

    }
}

