/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.task;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.logger.BuildLogger;
import com.atlassian.bamboo.build.logger.interceptors.ContentMatchingInterceptor;
import com.atlassian.bamboo.results.tests.TestResults;
import com.atlassian.bamboo.task.TaskContext;
import com.atlassian.bamboo.task.TaskIdentifier;
import com.atlassian.bamboo.task.TaskResult;
import com.atlassian.bamboo.task.TaskState;
import com.atlassian.bamboo.v2.build.CurrentBuildResult;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ProcessException;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public class TaskResultBuilder {
    private static final Logger log = Logger.getLogger(TaskResultBuilder.class);
    private final TaskContext taskContext;
    private final Map<String, String> taskResultData = Maps.newHashMap();
    private TaskState taskState;

    private TaskResultBuilder(@NotNull TaskContext taskContext) {
        this.taskContext = taskContext;
        this.taskState = TaskState.SUCCESS;
    }

    public static TaskResultBuilder create(@NotNull TaskContext taskContext) {
        return new TaskResultBuilder(taskContext);
    }

    public TaskResultBuilder success() {
        this.taskState = TaskState.SUCCESS;
        return this;
    }

    public TaskResultBuilder failed() {
        this.taskState = TaskState.FAILED;
        return this;
    }

    public TaskResultBuilder failedWithError() {
        this.taskState = TaskState.ERROR;
        return this;
    }

    public TaskResultBuilder checkReturnCode(@NotNull ExternalProcess externalProcess) {
        return this.checkReturnCode(externalProcess, 0);
    }

    public TaskResultBuilder checkReturnCode(@NotNull ExternalProcess externalProcess, int expectedReturnCode) {
        int exitCode = externalProcess.getHandler().getExitCode();
        if (this.taskState == TaskState.SUCCESS && exitCode != expectedReturnCode) {
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            log.info((Object)(buildLogger + buildLogger.addBuildLogEntry(String.format("Failing task since return code was %d while expected %d", exitCode, expectedReturnCode))));
            ProcessException e = externalProcess.getHandler().getException();
            if (e != null) {
                log.info((Object)"Process exception: ", (Throwable)e);
            }
            this.taskState = TaskState.FAILED;
        }
        return this;
    }

    public TaskResultBuilder checkTestFailures() {
        if (this.taskState == TaskState.SUCCESS) {
            int skippedTestResultsCount;
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            CurrentBuildResult buildResult = this.taskContext.getBuildContext().getBuildResult();
            Collection<TestResults> successfulTestResults = buildResult.getSuccessfulTestResults();
            Collection<TestResults> failedTestResults = buildResult.getFailedTestResults();
            Collection<TestResults> skippedTestResults = buildResult.getSkippedTestResults();
            int successfulTestResultsCount = successfulTestResults != null ? successfulTestResults.size() : 0;
            int failedTestResultsCount = failedTestResults != null ? failedTestResults.size() : 0;
            int n = skippedTestResultsCount = skippedTestResults != null ? skippedTestResults.size() : 0;
            if (failedTestResultsCount > 0) {
                log.info((Object)buildLogger.addBuildLogEntry(String.format("Failing task since %d failing test cases were found.", failedTestResultsCount)));
                this.taskState = TaskState.FAILED;
            } else if (successfulTestResultsCount == 0 && skippedTestResultsCount == 0) {
                log.info((Object)buildLogger.addBuildLogEntry("Failing task since test cases were expected but none were found."));
                this.taskState = TaskState.FAILED;
            }
        }
        return this;
    }

    public TaskResultBuilder checkInterceptorMatches(@NotNull ContentMatchingInterceptor interceptor, int maximumAge) {
        if (this.taskState == TaskState.SUCCESS && !interceptor.isMatchRecentEnough(maximumAge)) {
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            log.info((Object)buildLogger.addBuildLogEntry(String.format("Failing task since text '%s' was not found in last %d log entries", interceptor.getStringToMatch(), maximumAge)));
            this.taskState = TaskState.FAILED;
        }
        return this;
    }

    public TaskResultBuilder checkInterceptorNotMatches(@NotNull ContentMatchingInterceptor interceptor, int maximumAge) {
        if (this.taskState == TaskState.SUCCESS && interceptor.isMatchRecentEnough(maximumAge)) {
            BuildLogger buildLogger = this.taskContext.getBuildLogger();
            log.info((Object)buildLogger.addBuildLogEntry(String.format("Failing task since text '%s' was found in last %d log entries", interceptor.getStringToMatch(), maximumAge)));
            this.taskState = TaskState.FAILED;
        }
        return this;
    }

    public TaskResult build() {
        return new TaskResultImpl(this.taskState, this.taskContext, this.taskResultData);
    }

    public TaskState getTaskState() {
        return this.taskState;
    }

    private static final class TaskResultImpl
    implements TaskResult {
        private static final Logger log = Logger.getLogger(TaskResultImpl.class);
        private final TaskState taskState;
        private final TaskIdentifier taskIdentifier;
        private final Map<String, String> data;

        public TaskResultImpl(@NotNull TaskState taskState, @NotNull TaskContext taskContext) {
            this(taskState, taskContext, null);
        }

        public TaskResultImpl(@NotNull TaskState taskState, @NotNull TaskContext taskContext, @Nullable Map<String, String> taskResultData) {
            Preconditions.checkNotNull((Object)taskContext, (Object)"Could not create result as taskContext was null");
            this.taskState = taskState;
            this.taskIdentifier = new MinimalTaskIdentifier(taskContext);
            this.data = taskResultData != null ? taskResultData : Maps.newHashMap();
        }

        @Override
        @NotNull
        public TaskState getTaskState() {
            return this.taskState;
        }

        @Override
        @NotNull
        public Map<String, String> getResultData() {
            return this.data;
        }

        @Override
        @NotNull
        public TaskIdentifier getTaskIdentifier() {
            return this.taskIdentifier;
        }
    }

    private static final class MinimalTaskIdentifier
    implements TaskIdentifier,
    Serializable {
        private final long id;
        private final String pluginKey;
        private final String userDescription;
        private final boolean finalising;

        public MinimalTaskIdentifier(@NotNull TaskIdentifier taskIdentifier) {
            this.id = taskIdentifier.getId();
            this.pluginKey = taskIdentifier.getPluginKey();
            this.userDescription = taskIdentifier.getUserDescription();
            this.finalising = taskIdentifier.isFinalising();
        }

        @Override
        public long getId() {
            return this.id;
        }

        @Override
        @NotNull
        public String getPluginKey() {
            return this.pluginKey;
        }

        @Override
        @Nullable
        public String getUserDescription() {
            return this.userDescription;
        }

        @Override
        public boolean isFinalising() {
            return this.finalising;
        }
    }
}

