/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.build.Buildable;
import com.atlassian.bamboo.build.artifact.ArtifactLink;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.chains.ChainResultsSummary;
import com.atlassian.bamboo.chains.ChainStageResult;
import com.atlassian.bamboo.commit.UnassociatedCommit;
import com.atlassian.bamboo.jira.jiraissues.LinkedJiraIssue;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanKey;
import com.atlassian.bamboo.plan.PlanResultKey;
import com.atlassian.bamboo.resultsummary.BuildResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultDataRead;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCreationException;
import com.atlassian.bamboo.resultsummary.ResultsSummaryCriteria;
import com.atlassian.bamboo.v2.build.BuildContext;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@PublicApi
public interface ResultsSummaryManager {
    public <T extends ResultsSummary> T createResultsSummary(@NotNull BuildContext var1, @NotNull Class<T> var2) throws ResultsSummaryCreationException;

    @Nullable
    public ResultsSummary getResultsSummary(@NotNull PlanResultKey var1);

    @Nullable
    public ResultsSummary getResultsSummary(@NotNull PlanResultKey var1, ResultDataRead var2);

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey var1, @NotNull Class<T> var2);

    @Nullable
    public <T extends ResultsSummary> T getResultsSummary(@NotNull PlanResultKey var1, @NotNull Class<T> var2, ResultDataRead var3);

    public void updateLifeCycleState(@NotNull ResultsSummary var1, @NotNull LifeCycleState var2, @NotNull BuildState var3);

    public void updateLifeCycleState(@NotNull BuildContext var1, @NotNull LifeCycleState var2, @NotNull BuildState var3);

    public void updatePlanCompletedDate(@NotNull ChainResultsSummary var1, @NotNull Date var2);

    public void calculateAndSetDeltaState(ResultsSummary var1);

    public void saveResultSummary(@NotNull ResultsSummary var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllPendingResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllQueuedResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllInProgressResultSummaries(Class<T> var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllActiveResultSummariesForPlan(PlanKey var1, Class<T> var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getFinalizedResultSummariesForPlan(PlanKey var1, Class<T> var2, int var3, int var4);

    @NotNull
    public List<ResultsSummary> getNeighbouringSummaries(Plan var1, int var2);

    public int getNumberOfConcurrentlyRunningBuilds(PlanKey var1);

    @NotNull
    public <T extends ResultsSummary> Collection<T> getAllBuildResultSummariesInUnknownState(Class<T> var1);

    @Nullable
    public <T extends ResultsSummary> T findLastResultBefore(@NotNull PlanResultKey var1, Class<T> var2);

    @Nullable
    public ChainStageResult getChainStageResultById(@NotNull Long var1);

    @Deprecated
    @NotNull
    public <T extends ResultsSummary> List<T> getAllResultSummariesForPlan(@NotNull Plan var1);

    public long getNumberOfFinishedResults(@NotNull Plan var1);

    public long getNumberOfFinalizedResults(@NotNull Plan var1);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlan(@NotNull Plan var1, int var2, int var3);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesForPlanByLifeCycleState(@NotNull Plan var1, @NotNull LifeCycleState var2, int var3, int var4);

    public long getAveragePlanExecutionDuration(@NotNull Plan var1, int var2);

    public <T extends ResultsSummary> T getLastResultsSummary(@NotNull String var1, Class<T> var2);

    @Nullable
    public ResultsSummary getLastSuccessfulResultSummary(@NotNull PlanKey var1);

    public int removeResultsSummariesForPlan(Plan var1);

    public int removeAllOrphanedResultSummaries();

    @Nullable
    public ResultsSummary findFirstFailedBuildResultAfter(@NotNull String var1, int var2);

    @Nullable
    public ResultsSummary findFirstSuccessfulBuildResultAfter(@NotNull String var1, int var2);

    @Nullable
    public ResultsSummary findLastSuccessfulBuildResultBefore(@NotNull Plan var1, int var2);

    @Nullable
    public ResultsSummary findLastFailingBuildResultBefore(@NotNull Plan var1, int var2);

    @Nullable
    public ResultsSummary findFirstFailedBuildResultBetween(@NotNull Plan var1, int var2, int var3);

    @Nullable
    public ResultsSummary findLastBuildResultBefore(@NotNull String var1, int var2);

    @Nullable
    public <T extends ResultsSummary> T findLastBuildResultBeforeWithTests(@NotNull PlanResultKey var1, @NotNull Class<T> var2);

    @Nullable
    public ResultsSummary getBreakingBuild(ResultsSummary var1);

    @Nullable
    public ResultsSummary getFixingBuild(ResultsSummary var1);

    public void updateCancelledDetails(@NotNull ResultsSummary var1);

    public List<ResultsSummary> getLatestResultSummaries();

    public List<ResultsSummary> getLatestFailedResultSummaries();

    @NotNull
    public List<ResultsSummary> getLastNResultsSummaries(@NotNull Plan var1, int var2);

    @NotNull
    public List<ResultsSummary> getLastNFailedResultsSummaries(@NotNull Plan var1, int var2);

    @Deprecated
    @NotNull
    public List<BuildResultsSummary> getLastNBuildResultsSummaries(@NotNull Buildable var1, int var2);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummaries(@NotNull ResultsSummaryCriteria var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForResults(@NotNull List<ResultsSummary> var1);

    @NotNull
    public List<LinkedJiraIssue> findJiraIssuesForPlan(@NotNull Plan var1);

    @NotNull
    public List<? extends ResultsSummary> findResultsSummariesByJiraIssues(@Nullable List<String> var1);

    @NotNull
    public List<? extends ResultsSummary> findResultsSummariesByProjectKey(@Nullable String var1);

    @NotNull
    public List<BuildResultsSummary> getAllBuildResultsSummariesForAgent(@NotNull Long var1);

    @NotNull
    public List<BuildResultsSummary> getLatestSummariesForAgent(@NotNull Long var1, @NotNull Date var2);

    @NotNull
    public List<BuildResultsSummary> getLatestSummariesForAgent(@NotNull Long var1, int var2);

    @Nullable
    public BuildResultsSummary getLatestSummaryForAgent(long var1);

    @Nullable
    public ChainResultsSummary getParentResultSummary(ResultsSummary var1);

    @Nullable
    public ChainStageResult getStageForResult(ResultsSummary var1);

    public void removeResultSummary(@NotNull Plan var1, int var2);

    public void removeArtifacts(Plan var1, int var2);

    public void removeMatchingArtifacts(@NotNull ResultsSummary var1, @NotNull Predicate<ArtifactLink> var2);

    public void removeBuildLogs(Plan var1, int var2);

    public List<ChainResultsSummary> findChainResultsWithJobLabelled(ResultsSummaryCriteria var1, List<Label> var2);

    @Deprecated
    public void moveResultSummaries(PlanKey var1, PlanKey var2);

    public void moveResultSummaries(@NotNull Plan var1, @NotNull PlanKey var2, @NotNull PlanKey var3);

    public long scrollResultSummaries(@NotNull String var1, @NotNull Function<ResultsSummary, Void> var2);

    public long scrollResultSummaries(@NotNull String var1, ResultDataRead var2, @NotNull Function<ResultsSummary, Void> var3);

    @Nullable
    public <T extends ResultsSummary> T findFirstResultAfter(@NotNull PlanResultKey var1, Class<T> var2);

    @Nullable
    public <T extends ResultsSummary> T findLastResultSummaryWithState(@NotNull PlanKey var1, @NotNull BuildState var2, @NotNull Class<T> var3);

    @NotNull
    public <T extends ResultsSummary> List<T> getResultSummariesByChangeSetId(@NotNull String var1, Class<T> var2);

    @NotNull
    public List<UnassociatedCommit> getCommitsForUser(@NotNull String var1, int var2);

    public int countResultsWithState(@NotNull PlanKey var1, int var2, int var3, @NotNull BuildState var4);

    public void logVariablesForSubstitution(@NotNull BuildContext var1, @NotNull ResultsSummary var2);

    public void logSubstitutedVariables(@NotNull BuildContext var1, @NotNull ResultsSummary var2);

    public void updateProcessingDuration(ChainResultsSummary var1);
}

