/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.resultsummary;

import com.atlassian.annotations.PublicApi;
import com.atlassian.bamboo.builder.BuildState;
import com.atlassian.bamboo.builder.LifeCycleState;
import com.atlassian.bamboo.labels.Label;
import com.atlassian.bamboo.resultsummary.ResultsSummary;
import com.atlassian.fage.Option;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@PublicApi
public class ResultsSummaryCriteria
implements Cloneable {
    private static final Logger log = Logger.getLogger(ResultsSummaryCriteria.class);
    private String projectKey;
    private String buildKey;
    private BuildState buildState;
    private Date fromDate;
    private Date toDate;
    private Date fromCreationDate;
    private Date toCreationDate;
    private int fromBuildNumber;
    private int toBuildNumber;
    private Long agentId;
    private List<Label> matchesLabels;
    private List<String> matchesJiraIssues;
    private List<String> matchesCustomDataKeys;
    private int maxRowCount;
    private String sortField;
    private boolean sortAscending;
    private Option<Boolean> continuable = Option.none();
    private Class<? extends ResultsSummary> resultSummaryClass = ResultsSummary.class;
    private Set<LifeCycleState> lifeCycleStates = EnumSet.of(LifeCycleState.FINISHED);

    public ResultsSummaryCriteria() {
    }

    public ResultsSummaryCriteria(Class<? extends ResultsSummary> resultSummaryClass) {
        this.resultSummaryClass = resultSummaryClass;
    }

    public ResultsSummaryCriteria(String buildKey, Date fromDate, Date toDate) {
        this.buildKey = buildKey;
        this.fromDate = fromDate;
        this.toDate = toDate;
    }

    public ResultsSummaryCriteria(String buildKey, int fromBuildNumber, int toBuildNumber) {
        this.buildKey = buildKey;
        this.fromBuildNumber = fromBuildNumber;
        this.toBuildNumber = toBuildNumber;
    }

    public ResultsSummaryCriteria(String buildKey, Date fromDate, Date toDate, int fromBuildNumber, int toBuildNumber) {
        this.buildKey = buildKey;
        this.fromDate = fromDate;
        this.toDate = toDate;
        this.fromBuildNumber = fromBuildNumber;
        this.toBuildNumber = toBuildNumber;
    }

    public ResultsSummaryCriteria(String buildKey) {
        this.buildKey = buildKey;
    }

    public ResultsSummaryCriteria(String planKey, boolean sortAscending) {
        this.buildKey = planKey;
        this.sortAscending = sortAscending;
    }

    public ResultsSummaryCriteria(String planKey, int numberOfResults) {
        this.buildKey = planKey;
        this.maxRowCount = numberOfResults;
    }

    public ResultsSummaryCriteria(String planKey, BuildState buildState) {
        this.buildKey = planKey;
        this.buildState = buildState;
    }

    public String getProjectKey() {
        return this.projectKey;
    }

    public void setProjectKey(String projectKey) {
        this.projectKey = projectKey;
    }

    public BuildState getBuildState() {
        return this.buildState;
    }

    public void setBuildState(BuildState buildState) {
        this.buildState = buildState;
    }

    public boolean isSortAscending() {
        return this.sortAscending;
    }

    public void setBuildKey(String buildKey) {
        this.buildKey = buildKey;
    }

    public void setSortAscending(boolean sortAscending) {
        this.sortAscending = sortAscending;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public Date getFromCreationDate() {
        return this.fromCreationDate;
    }

    public void setFromCreationDate(Date fromCreationDate) {
        this.fromCreationDate = fromCreationDate;
    }

    public Date getToCreationDate() {
        return this.toCreationDate;
    }

    public void setToCreationDate(Date toCreationDate) {
        this.toCreationDate = toCreationDate;
    }

    public int getFromBuildNumber() {
        return this.fromBuildNumber;
    }

    public int getToBuildNumber() {
        return this.toBuildNumber;
    }

    public String getBuildKey() {
        return this.buildKey;
    }

    public List<Label> getMatchesLabels() {
        return this.matchesLabels;
    }

    public List<String> getMatchesJiraIssues() {
        return this.matchesJiraIssues;
    }

    public void setMatchesJiraIssues(List<String> matchesJiraIssues) {
        this.matchesJiraIssues = matchesJiraIssues;
    }

    public void setMatchesLabels(List<Label> matchesLabels) {
        this.matchesLabels = matchesLabels;
    }

    public List<String> getMatchesCustomDataKeys() {
        return this.matchesCustomDataKeys;
    }

    public void setMatchesCustomDataKeys(List<String> matchesCustomDataKeys) {
        this.matchesCustomDataKeys = matchesCustomDataKeys;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setFromBuildNumber(int fromBuildNumber) {
        this.fromBuildNumber = fromBuildNumber;
    }

    public Long getAgentId() {
        return this.agentId;
    }

    public void setAgentId(Long agentId) {
        this.agentId = agentId;
    }

    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    public void setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
    }

    public void setToBuildNumber(int toBuildNumber) {
        this.toBuildNumber = toBuildNumber;
    }

    public String getSortField() {
        return this.sortField;
    }

    public void setSortField(String sortField) {
        this.sortField = sortField;
    }

    public Collection<LifeCycleState> getLifeCycleStates() {
        return this.lifeCycleStates;
    }

    public void setLifeCycleStates(Set<LifeCycleState> lifeCycleStates) {
        this.lifeCycleStates = lifeCycleStates;
    }

    public Option<Boolean> getContinuable() {
        return this.continuable;
    }

    public void setContinuable(Option<Boolean> continuable) {
        this.continuable = continuable;
    }

    @NotNull
    public Class<? extends ResultsSummary> getResultSummaryClass() {
        return this.resultSummaryClass;
    }

    public void setResultSummaryClass(@NotNull Class<? extends ResultsSummary> resultSummaryClass) {
        this.resultSummaryClass = resultSummaryClass;
    }

    public ResultsSummaryCriteria clone() {
        try {
            ResultsSummaryCriteria clone = (ResultsSummaryCriteria)super.clone();
            if (this.matchesLabels != null) {
                clone.setMatchesLabels(Lists.newArrayList(this.matchesLabels));
            }
            if (this.matchesJiraIssues != null) {
                clone.setMatchesJiraIssues(Lists.newArrayList(this.matchesJiraIssues));
            }
            if (this.matchesCustomDataKeys != null) {
                clone.setMatchesCustomDataKeys(Lists.newArrayList(this.matchesCustomDataKeys));
            }
            return clone;
        }
        catch (Exception e) {
            log.warn((Object)("Unable to clone " + this), (Throwable)e);
            throw new RuntimeException("Unable to clone " + this, e);
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 11).append((Object)this.getProjectKey()).append((Object)this.getBuildKey()).append(this.getFromBuildNumber()).append(this.getToBuildNumber()).append((Object)this.getFromDate()).append((Object)this.getToDate()).append(this.getResultSummaryClass()).append(this.getLifeCycleStates()).append(this.getContinuable()).toHashCode();
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResultsSummaryCriteria)) {
            return false;
        }
        ResultsSummaryCriteria rhs = (ResultsSummaryCriteria)o;
        return new EqualsBuilder().append((Object)this.getProjectKey(), (Object)rhs.getProjectKey()).append((Object)this.getBuildKey(), (Object)rhs.getBuildKey()).append(this.getFromBuildNumber(), rhs.getFromBuildNumber()).append(this.getToBuildNumber(), rhs.getToBuildNumber()).append((Object)this.getFromDate(), (Object)rhs.getFromDate()).append((Object)this.getToDate(), (Object)rhs.getToDate()).append(this.getResultSummaryClass(), rhs.getResultSummaryClass()).append(this.getLifeCycleStates(), rhs.getLifeCycleStates()).append(this.getContinuable(), rhs.getContinuable()).isEquals();
    }

    public int compareTo(Object obj) {
        ResultsSummaryCriteria o = (ResultsSummaryCriteria)obj;
        return new CompareToBuilder().append((Object)this.getProjectKey(), (Object)o.getProjectKey()).append((Object)this.getBuildKey(), (Object)o.getBuildKey()).append(this.getFromBuildNumber(), o.getFromBuildNumber()).append(this.getToBuildNumber(), o.getToBuildNumber()).append((Object)this.getFromDate(), (Object)o.getFromDate()).append((Object)this.getToDate(), (Object)o.getToDate()).append(this.getResultSummaryClass(), o.getResultSummaryClass()).append(this.getLifeCycleStates(), o.getLifeCycleStates()).append(this.getContinuable(), o.getContinuable()).toComparison();
    }
}

