/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.plan;

import com.atlassian.annotations.Internal;
import com.atlassian.bamboo.plan.Plan;
import com.atlassian.bamboo.plan.PlanExecutionPermitter;
import com.atlassian.bamboo.utils.error.ErrorCollection;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Internal
public abstract class AbstractPlanExecutionPermitter
implements PlanExecutionPermitter {
    private static final Logger log = Logger.getLogger(AbstractPlanExecutionPermitter.class);
    private PlanExecutionPermitter chainedExecutionPermitter;

    @Override
    public boolean isPermittedToExecute(@NotNull Plan plan, @NotNull ErrorCollection errorCollection) {
        if (!this.isPermittedToExecuteImpl(plan, errorCollection)) {
            return false;
        }
        return this.chainedExecutionPermitter == null || this.chainedExecutionPermitter.isPermittedToExecute(plan, errorCollection);
    }

    @Override
    public void setChainedExecutionPermitter(PlanExecutionPermitter chainedExecutionPermitter) {
        this.chainedExecutionPermitter = chainedExecutionPermitter;
    }

    protected abstract boolean isPermittedToExecuteImpl(@NotNull Plan var1, @NotNull ErrorCollection var2);
}

