/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.bandana;

import com.atlassian.bamboo.bandana.BambooBandanaContext;
import com.atlassian.plugin.Plugin;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.builder.CompareToBuilder;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlanAwareBandanaContext
implements BambooBandanaContext,
Comparable<PlanAwareBandanaContext> {
    private static final Logger log = Logger.getLogger(PlanAwareBandanaContext.class);
    public static final PlanAwareBandanaContext GLOBAL_CONTEXT = new PlanAwareBandanaContext(0L);
    private final long planId;
    private final String pluginKey;

    public PlanAwareBandanaContext(long planId) {
        this(planId, null);
    }

    public PlanAwareBandanaContext(long planId, @Nullable String pluginKey) {
        this.planId = planId;
        this.pluginKey = pluginKey;
    }

    public static PlanAwareBandanaContext forPlugin(long planId, @NotNull Plugin plugin) {
        return new PlanAwareBandanaContext(planId, ((Plugin)Preconditions.checkNotNull((Object)plugin, (Object)"plugin")).getKey());
    }

    @Override
    public boolean isGlobal() {
        return this.getPlanId() <= 0L;
    }

    @Override
    public long getPlanId() {
        return this.planId;
    }

    @Override
    public BambooBandanaContext getParentContext() {
        return this.isGlobal() ? null : GLOBAL_CONTEXT;
    }

    @Override
    public String getPluginKey() {
        return this.pluginKey;
    }

    public boolean hasParentContext() {
        return !this.isGlobal();
    }

    public int hashCode() {
        return new HashCodeBuilder(31, 7).append(this.getPlanId()).append((Object)this.getPluginKey()).toHashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof PlanAwareBandanaContext)) {
            return false;
        }
        PlanAwareBandanaContext rhs = (PlanAwareBandanaContext)other;
        return new EqualsBuilder().append(this.getPlanId(), rhs.getPlanId()).append((Object)this.getPluginKey(), (Object)rhs.getPluginKey()).isEquals();
    }

    @Override
    public int compareTo(PlanAwareBandanaContext other) {
        return new CompareToBuilder().append(this.getPlanId(), other.getPlanId()).append((Object)this.getPluginKey(), (Object)other.getPluginKey()).toComparison();
    }
}

