/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap.http;

import com.atlassian.bamboo.agent.bootstrap.SslKeystoreUtils;
import com.atlassian.bamboo.agent.bootstrap.http.FixedVirtualHostInterceptor;
import com.atlassian.bamboo.agent.bootstrap.http.SchemeRegistryFactory;
import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLInitializationException;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.impl.conn.SystemDefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class RemoteAgentHttpClientFactory
implements Serializable {
    private static final Logger log = Logger.getLogger(RemoteAgentHttpClientFactory.class);
    private static final String PROPERTY_HTTP_CLIENT_TIMEOUT = "bamboo.agent.http.client.timeout";
    private static final String PROPERTY_HTTP_CLIENT_RETRIES = "bamboo.agent.http.client.retries";
    public static final String BAMBOO_AGENT_IGNORE_SERVER_CERT_NAME = "bamboo.agent.ignoreServerCertName";
    private static final int DEFAULT_HTTP_CLIENT_TIMEOUT_SECONDS = 300;
    private static final int DEFAULT_HTTP_CLIENT_RETRIES = 10;
    private int retries = RemoteAgentHttpClientFactory.getRetries();
    private int timeoutMs = RemoteAgentHttpClientFactory.getTimeoutMs();
    @Nullable
    private HostnameVerifier hostnameVerifierOverride;
    private SchemeRegistryFactory schemeRegistryDataFactory;
    private String fixedVirtualHost;

    public CloseableHttpClient newHttpClient() {
        log.info((Object)"Creating a new HTTP client...");
        DefaultHttpRequestRetryHandler retryhandler = new DefaultHttpRequestRetryHandler(this.retries, true){

            public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
                boolean rc = super.retryRequest(exception, executionCount, context);
                if (exception instanceof SocketTimeoutException) {
                    return executionCount < this.getRetryCount();
                }
                return rc;
            }
        };
        SocketConfig socketConfig = SocketConfig.custom().setSoTimeout(this.timeoutMs).build();
        RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(this.timeoutMs).setSocketTimeout(this.timeoutMs).build();
        Registry<ConnectionSocketFactory> schemeRegistry = RemoteAgentHttpClientFactory.getSchemeRegistry(this.schemeRegistryDataFactory.newSchemeRegistry(this));
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(schemeRegistry);
        connManager.setDefaultSocketConfig(socketConfig);
        HttpClientBuilder clientBuilder = HttpClientBuilder.create().setConnectionManager((HttpClientConnectionManager)connManager).setRetryHandler((HttpRequestRetryHandler)retryhandler).setDefaultSocketConfig(socketConfig).setDefaultRequestConfig(requestConfig);
        HostnameVerifier hostnameVerifier = this.chooseHostnameVerifier();
        if (hostnameVerifier != null) {
            clientBuilder.setSSLHostnameVerifier(hostnameVerifier);
        }
        if (this.fixedVirtualHost != null) {
            clientBuilder.addInterceptorFirst((HttpRequestInterceptor)new FixedVirtualHostInterceptor(this.fixedVirtualHost));
        }
        clientBuilder.setRoutePlanner((HttpRoutePlanner)new SystemDefaultRoutePlanner(null));
        return clientBuilder.build();
    }

    public SSLConnectionSocketFactory newSslConnectionSocketFactory() throws SSLInitializationException {
        try {
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            if (SslKeystoreUtils.isKeyStoreConfigured()) {
                try {
                    String keystorePassword = SslKeystoreUtils.getKeystorePassword();
                    if (keystorePassword == null) {
                        keystorePassword = "";
                    }
                    KeyStore keystore = SslKeystoreUtils.loadKeyStore();
                    sslContextBuilder.loadKeyMaterial(keystore, keystorePassword.toCharArray());
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to load key store", (Throwable)e);
                }
            }
            if (SslKeystoreUtils.isTrustStoreConfigured()) {
                try {
                    KeyStore truststore = SslKeystoreUtils.loadTrustStore();
                    sslContextBuilder.loadTrustMaterial(truststore, (TrustStrategy)new TrustSelfSignedStrategy());
                }
                catch (Exception e) {
                    log.warn((Object)"Unable to load trust store", (Throwable)e);
                }
            }
            SSLContext sslContext = sslContextBuilder.build();
            this.removeUndesirableCiphers(sslContext.getDefaultSSLParameters());
            HostnameVerifier hostnameVerifier = this.chooseHostnameVerifier();
            return hostnameVerifier == null ? new SSLConnectionSocketFactory(sslContext) : new SSLConnectionSocketFactory(sslContext, hostnameVerifier);
        }
        catch (Exception e) {
            throw new SSLInitializationException("Error during intialisation of SSL connection factory: ", (Throwable)e);
        }
    }

    private void removeUndesirableCiphers(SSLParameters sslParameters) {
        String[] cipherSuites = sslParameters.getCipherSuites();
        ArrayList<String> desirableCiphers = new ArrayList<String>();
        for (String cipherSuite : cipherSuites) {
            if (cipherSuite.contains("_GCM_")) continue;
            desirableCiphers.add(cipherSuite);
        }
        sslParameters.setCipherSuites(desirableCiphers.toArray(new String[0]));
    }

    public void setSchemeRegistryDataFactory(SchemeRegistryFactory schemeRegistryData) {
        this.schemeRegistryDataFactory = schemeRegistryData;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setTimeoutMs(int timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifierOverride = hostnameVerifier;
    }

    public void setFixedVirtualHost(String virtualHost) {
        this.fixedVirtualHost = virtualHost;
    }

    private HostnameVerifier chooseHostnameVerifier() {
        if (this.hostnameVerifierOverride != null) {
            return this.hostnameVerifierOverride;
        }
        if (Boolean.getBoolean(BAMBOO_AGENT_IGNORE_SERVER_CERT_NAME)) {
            log.info((Object)"Allowing non-matching certificates in HTTPClient");
            return NoopHostnameVerifier.INSTANCE;
        }
        return null;
    }

    private static Registry<ConnectionSocketFactory> getSchemeRegistry(Map<String, ConnectionSocketFactory> schemeRegistryData) {
        RegistryBuilder builder = RegistryBuilder.create();
        for (Map.Entry<String, ConnectionSocketFactory> entry : schemeRegistryData.entrySet()) {
            builder.register(entry.getKey(), (Object)entry.getValue());
        }
        return builder.build();
    }

    private static int getRetries() {
        return Integer.getInteger(PROPERTY_HTTP_CLIENT_RETRIES, 10);
    }

    public static int getTimeoutMs() {
        Integer integer = Integer.getInteger(PROPERTY_HTTP_CLIENT_TIMEOUT, 300);
        return (int)TimeUnit.SECONDS.toMillis(integer.intValue());
    }

    private static class TunnelAwareRoutePlanner
    extends SystemDefaultRoutePlanner {
        private TunnelAwareRoutePlanner() {
            super(null);
        }

        public HttpRoute determineRoute(HttpHost host, HttpRequest request, HttpContext context) throws HttpException {
            HttpRoute httpRoute = super.determineRoute(host, request, context);
            HttpHost target = httpRoute.getTargetHost();
            InetAddress local = httpRoute.getLocalAddress();
            HttpHost proxy = httpRoute.getProxyHost();
            boolean secure = request.getRequestLine().getUri().startsWith("https");
            if (proxy == null) {
                return new HttpRoute(target, local, secure);
            }
            return new HttpRoute(target, local, proxy, secure);
        }
    }
}

