/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.utils.HttpUtils;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.log4j.Logger;

public class RemoteAgentHttpClient {
    private static final Logger log = Logger.getLogger(RemoteAgentHttpClient.class);
    private static final String PROPERTY_HTTP_CLIENT_TIMEOUT = "bamboo.agent.http.client.timeout";
    private static final String PROPERTY_HTTP_CLIENT_RETRIES = "bamboo.agent.http.client.retries";
    private static final int DEFAULT_HTTP_CLIENT_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_HTTP_CLIENT_RETRIES = 30;

    private RemoteAgentHttpClient() {
    }

    public static HttpClient newHttpClient() {
        return RemoteAgentHttpClient.newHttpClient(Integer.getInteger(PROPERTY_HTTP_CLIENT_TIMEOUT, 30), Integer.getInteger(PROPERTY_HTTP_CLIENT_RETRIES, 30));
    }

    public static HttpClient newHttpClient(int timeoutSeconds, int retries) {
        MultiThreadedHttpConnectionManager manager = new MultiThreadedHttpConnectionManager();
        manager.getParams().setConnectionTimeout((int)TimeUnit.SECONDS.toMillis(timeoutSeconds));
        manager.getParams().setSoTimeout((int)TimeUnit.SECONDS.toMillis(timeoutSeconds));
        DefaultHttpMethodRetryHandler retryhandler = new DefaultHttpMethodRetryHandler(retries, true){

            public boolean retryMethod(HttpMethod method, IOException exception, int executionCount) {
                boolean rc = super.retryMethod(method, exception, executionCount);
                if (exception instanceof SocketTimeoutException) {
                    return executionCount < this.getRetryCount();
                }
                return rc;
            }
        };
        HttpClient client = new HttpClient((HttpConnectionManager)manager);
        client.getParams().setParameter("http.method.retry-handler", (Object)retryhandler);
        HttpUtils.EndpointSpec proxyForScheme = HttpUtils.getProxyForScheme(null);
        if (proxyForScheme != null) {
            client.getHostConfiguration().setProxy(proxyForScheme.host, proxyForScheme.port.intValue());
        }
        return client;
    }
}

