/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import com.atlassian.bamboo.agent.AgentType;
import com.atlassian.bamboo.agent.BambooHttpUtils;
import com.atlassian.bamboo.agent.bootstrap.AgentRunner;
import com.atlassian.bamboo.agent.bootstrap.AgentUuidInitializer;
import com.atlassian.bamboo.agent.bootstrap.BootstrapUpdater;
import com.atlassian.bamboo.agent.bootstrap.ClasspathBuilder;
import com.atlassian.bamboo.agent.bootstrap.GetFingerprintResponse;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHomeLocatorForBootstrap;
import com.atlassian.bamboo.agent.bootstrap.RemoteAgentHttpException;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class AgentContext {
    private static final Logger log = Logger.getLogger(AgentContext.class);
    public static final String SERVER_AUTH_POLL_INTERVAL = "bamboo.agent.auth.pollInterval";
    public static final String FINGERPRINT_PARAM = "fingerprint";
    public static final String VERSION_PARAM = "version";
    public static final String UUID_PARAM = "agentUuid";
    public static final String DISABLE_BOOTSTRAP_UPDATE = "disableBootstrapUpdate";
    public static final String BOOTSTRAP_VERSION = "3";
    private final HttpClient httpClient;
    private final URL baseUrl;
    private final String fingerPrintRequestSuffix;
    private final AgentType agentBootstrapType;
    private final long serverPollInterval;
    private final UUID agentUuid;
    private volatile String agentClassName;
    private volatile ClassLoader agentClassLoader;
    private volatile String fingerprint;
    private volatile Map<String, String> userProperties;

    public AgentContext(HttpClient httpClient, URL baseUrl, String fingerPrintRequestSuffix, AgentType agentBootstrapType) throws MalformedURLException {
        this.httpClient = httpClient;
        this.baseUrl = this.withTrailingSlash(baseUrl);
        this.fingerPrintRequestSuffix = fingerPrintRequestSuffix;
        this.agentBootstrapType = agentBootstrapType;
        this.serverPollInterval = Long.getLong(SERVER_AUTH_POLL_INTERVAL, 60L);
        AgentUuidInitializer uuidInitializer = new AgentUuidInitializer();
        this.agentUuid = uuidInitializer.initUuid();
    }

    private URL withTrailingSlash(URL baseUrl) throws MalformedURLException {
        if (baseUrl.getPath().endsWith("/")) {
            return baseUrl;
        }
        return new URL(baseUrl.toString() + "/");
    }

    protected void run() throws ClassNotFoundException, IOException {
        this.initServerSession();
        log.info((Object)("Bootstrap Type: '" + this.agentBootstrapType + "'"));
        Thread thread = new Thread(new AgentRunner(this, this.agentClassName));
        thread.setContextClassLoader(this.getAgentClassLoader());
        thread.start();
    }

    private void initServerSession() throws IOException, ClassNotFoundException {
        this.initFingerprint();
        this.updateBootstrapIfNecessary(this.agentBootstrapType);
        this.agentClassLoader = this.getClassLoader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFingerprint() throws IOException {
        String fingerprintRequestUrl = this.createFingerprintUrl(this.getHostname());
        log.info((Object)("Requesting fingerprint, url: " + fingerprintRequestUrl));
        int statusCode = 0;
        do {
            GetMethod method = new GetMethod(fingerprintRequestUrl);
            try {
                this.httpClient.executeMethod((HttpMethod)method);
                statusCode = method.getStatusCode();
                if (statusCode == 200) {
                    log.info((Object)("Successfully authenticated with Bamboo server at " + this.baseUrl + " "));
                    GetFingerprintResponse fingerprintResponse = new GetFingerprintResponse(method.getResponseBodyAsStream());
                    this.validateBootstrapVersion(fingerprintResponse);
                    this.fingerprint = fingerprintResponse.getFingerprint();
                    this.agentClassName = fingerprintResponse.getAgentClassName();
                    this.userProperties = fingerprintResponse.getUserProperties();
                    continue;
                }
                if (statusCode == 401) {
                    log.warn((Object)this.logStrings("This agent requires manual approval. Message from the server is:", BambooHttpUtils.toString((HttpMethodBase)method), String.format("Next authentication attempt in %d seconds... ", this.serverPollInterval)));
                    this.haveSomeSleep();
                    continue;
                }
                throw new RemoteAgentHttpException(statusCode, "fingerprint request");
            }
            finally {
                method.releaseConnection();
            }
        } while (statusCode != 200);
    }

    private String logStrings(String ... logs) {
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n********************************************************************************\n");
        sb.append("*\n");
        for (String s : logs) {
            sb.append("* ").append(s).append("\n");
        }
        sb.append("*\n");
        sb.append("********************************************************************************\n");
        return sb.toString();
    }

    private String createFingerprintUrl(String hostName) {
        return this.baseUrl + "GetFingerprint.action?hostName=" + hostName + this.fingerPrintRequestSuffix + "&" + VERSION_PARAM + "=" + BOOTSTRAP_VERSION + "&" + UUID_PARAM + "=" + this.agentUuid.toString();
    }

    private void haveSomeSleep() {
        try {
            TimeUnit.SECONDS.sleep(this.serverPollInterval);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void validateBootstrapVersion(GetFingerprintResponse fingerprintResponse) throws ProtocolException {
        String bootstrapVersion = fingerprintResponse.getBootstrapVersion();
        if (bootstrapVersion == null) {
            throw new ProtocolException("Server has not specified Agent bootstrap version.  Please re-install the agent.");
        }
        if (!bootstrapVersion.equals("1")) {
            throw new ProtocolException("Server requires Agent bootstrap version " + bootstrapVersion + ".  Please re-install the agent.");
        }
    }

    private void updateBootstrapIfNecessary(AgentType agentBootstrapType) throws IOException {
        boolean isLatestBootstrap;
        if (agentBootstrapType == AgentType.REMOTE && System.getProperty(DISABLE_BOOTSTRAP_UPDATE) == null && !(isLatestBootstrap = BootstrapUpdater.ensureLatestBootstrap(this))) {
            log.info((Object)"Important agent classes have been updated, the agent will now terminate to pick up the latest changes.");
            System.exit(0);
        }
    }

    public String getFingerprint() {
        return this.fingerprint;
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public String getAbsoluteURL(String relativeUrl) {
        String url = AgentContext.addParameter(this.baseUrl + relativeUrl, FINGERPRINT_PARAM, this.fingerprint);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Requesting: " + url));
        }
        return url;
    }

    public static String addParameter(String url, String name, String value) {
        return url + (url.contains("?") ? "&" : "?") + name + "=" + value;
    }

    private ClassLoader getAgentClassLoader() {
        return this.agentClassLoader;
    }

    public HttpClient getHttpClient() {
        return this.httpClient;
    }

    public Map<String, String> getUserProperties() {
        return this.userProperties;
    }

    public AgentType getAgentBootstrapType() {
        return this.agentBootstrapType;
    }

    public UUID getAgentUuid() {
        return this.agentUuid;
    }

    public static void systemExit(@Nullable String reason, @Nullable Throwable throwable) {
        if (reason != null && throwable != null) {
            log.fatal((Object)("Agent encountered a fatal error: '" + reason + "'. Exiting."), throwable);
        } else if (reason != null) {
            log.fatal((Object)("Agent encountered a fatal error: '" + reason + "'. Exiting."), (Throwable)new Error());
        } else {
            log.fatal((Object)"Agent encountered a fatal error. Exiting.", (Throwable)new Error());
        }
        System.exit(1);
    }

    private String getHostname() {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            log.warn((Object)"Cannot determine local host name; using \"localhost\".", (Throwable)e);
            hostName = "localhost";
        }
        return hostName;
    }

    private ClassLoader getClassLoader() throws IOException, ClassNotFoundException {
        File home = RemoteAgentHomeLocatorForBootstrap.getHome();
        File classPathDirectory = new File(home, "classpath");
        if (!classPathDirectory.exists() && !classPathDirectory.mkdirs()) {
            throw new IOException("Could not create directory '" + classPathDirectory.getAbsolutePath() + "'");
        }
        LinkedList<File> classPathDirectories = new LinkedList<File>();
        classPathDirectories.add(classPathDirectory);
        File agentInstallationDirectory = RemoteAgentHomeLocatorForBootstrap.getInstallationDirectory();
        File libDirectory = new File(agentInstallationDirectory, "lib");
        if (libDirectory.isDirectory()) {
            classPathDirectories.add(libDirectory);
        }
        return ClasspathBuilder.build(home, classPathDirectories, this);
    }
}

