/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bamboo.agent.bootstrap;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.log4j.Logger;

public final class RemoteAgentHomeLocatorForBootstrap {
    private static final Logger log = Logger.getLogger(RemoteAgentHomeLocatorForBootstrap.class);
    private static final String BAMBOO_INIT_PROPERTIES = "bamboo-init.properties";
    public static final String BAMBOO_HOME_PROPERTY = "bamboo.home";
    public static final String BAMBOO_AGENT_HOME_PROPERTY = "bamboo.agent.home";

    private RemoteAgentHomeLocatorForBootstrap() {
    }

    public static File getHome() {
        String home = RemoteAgentHomeLocatorForBootstrap.getFirstNonBlank(RemoteAgentHomeLocatorForBootstrap.getHomeFromConfigFile(), RemoteAgentHomeLocatorForBootstrap.getAgentHomeFromPropertyOrEnv(), System.getProperty("user.home") + File.separator + "bamboo-agent-home");
        log.info((Object)("Agent home located at '" + home + "'"));
        return new File(home);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getHomeFromConfigFile() {
        String confHome;
        block10: {
            log.debug((Object)"Trying to load bamboo-init.properties from properties file... ");
            confHome = null;
            try {
                Properties props = new Properties();
                URL url = RemoteAgentHomeLocatorForBootstrap.class.getClassLoader().getResource(BAMBOO_INIT_PROPERTIES);
                if (url != null) {
                    InputStream inputStream = null;
                    try {
                        inputStream = url.openStream();
                        props.load(inputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                if (props.getProperty(BAMBOO_HOME_PROPERTY) != null) {
                    confHome = props.getProperty(BAMBOO_HOME_PROPERTY);
                } else {
                    log.debug((Object)"Could not find bamboo.home property in the bamboo-init.properties file. trying other methods.");
                }
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block10;
                log.debug((Object)"Could not find bamboo.home in the classpath, trying other methods.");
            }
        }
        return confHome;
    }

    public static String getAgentHomeFromPropertyOrEnv() {
        return RemoteAgentHomeLocatorForBootstrap.getFirstNonBlank(System.getProperty(BAMBOO_AGENT_HOME_PROPERTY), System.getProperty(BAMBOO_HOME_PROPERTY), System.getenv("BAMBOO_HOME"));
    }

    private static String getFirstNonBlank(String ... vals) {
        for (String val : vals) {
            if (RemoteAgentHomeLocatorForBootstrap.isBlank(val)) continue;
            return val;
        }
        return "";
    }

    private static boolean isBlank(String test) {
        return test == null || test.trim().equals("");
    }
}

