/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.DnsResolver;
import com.atlassian.aws.SortingDnsResolver;

@Deprecated
public class HttpClientConfigurationUtilsDoNotUse {
    private static final String HTTPS = "https";
    private static final String HTTP = "http";

    private HttpClientConfigurationUtilsDoNotUse() {
    }

    public static ClientConfiguration newClientConfiguration(int transmissionTimeoutMs, int maxRetries) {
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        HttpClientConfigurationUtilsDoNotUse.applyTimeoutSettings(clientConfiguration, transmissionTimeoutMs, maxRetries);
        HttpClientConfigurationUtilsDoNotUse.applyProxyProperties(clientConfiguration);
        HttpClientConfigurationUtilsDoNotUse.applyDnsResolver(clientConfiguration);
        return clientConfiguration;
    }

    private static void applyDnsResolver(ClientConfiguration clientConfiguration) {
        DnsResolver dnsResolver = clientConfiguration.getDnsResolver();
        clientConfiguration.setDnsResolver((DnsResolver)new SortingDnsResolver(dnsResolver));
    }

    public static ClientConfiguration applyTimeoutSettings(ClientConfiguration clientConfiguration, int timeoutMs, int maxRetries) {
        return clientConfiguration.withSocketTimeout(timeoutMs).withConnectionTimeout(timeoutMs).withMaxErrorRetry(maxRetries);
    }

    public static ClientConfiguration applyProxyProperties(ClientConfiguration clientConfiguration) {
        if (!HttpClientConfigurationUtilsDoNotUse.applyProxyProperties(clientConfiguration, HTTPS)) {
            HttpClientConfigurationUtilsDoNotUse.applyProxyProperties(clientConfiguration, HTTP);
        }
        return clientConfiguration;
    }

    private static boolean applyProxyProperties(ClientConfiguration clientConfiguration, String protocol) {
        String proxyHost = HttpClientConfigurationUtilsDoNotUse.getSystemProperty(protocol, "proxyHost");
        String proxyPortString = HttpClientConfigurationUtilsDoNotUse.getSystemProperty(protocol, "proxyPort");
        int proxyPort = HttpClientConfigurationUtilsDoNotUse.toInt(proxyPortString, -1);
        if (proxyHost == null || proxyPort <= 0) {
            return false;
        }
        clientConfiguration.withProxyHost(proxyHost).withProxyPort(proxyPort);
        String proxyDomain = HttpClientConfigurationUtilsDoNotUse.getSystemProperty(protocol, "proxyDomain");
        String proxyUser = HttpClientConfigurationUtilsDoNotUse.getSystemProperty(protocol, "proxyUser");
        String proxyPassword = HttpClientConfigurationUtilsDoNotUse.getSystemProperty(protocol, "proxyPassword");
        String proxyWorkstation = HttpClientConfigurationUtilsDoNotUse.getSystemProperty(protocol, "proxyWorkstation");
        clientConfiguration.withProxyUsername(proxyUser).withProxyPassword(proxyPassword).withProxyDomain(proxyDomain).withProxyWorkstation(proxyWorkstation);
        return true;
    }

    private static String getSystemProperty(String protocol, String proxyHost) {
        return System.getProperty(protocol + "." + proxyHost);
    }

    public static int toInt(String str, int defaultValue) {
        if (str == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

