package com.atlassian.aws.utils;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.NoRouteToHostException;
import java.nio.charset.Charset;

/**
 * <p>Utility methods for working with {@link URLFetcher}s.</p>
 */
public class URLFetcherUtils
{
    private static volatile URLFetcher urlFetcher = new URLFetcherImpl();

    private URLFetcherUtils()
    {
    }

    /**
     * @return The singleton {@link URLFetcher}
     */
    public static URLFetcher getURLFetcher()
    {
        return urlFetcher;
    }

    /**
     * <p>Sets the singleton {@link URLFetcher}.</p>
     *
     * @param urlFetcher
     *  The singleton URLFetcher.
     */
    public static void setURLFetcher(final URLFetcher urlFetcher)
    {
        URLFetcherUtils.urlFetcher = urlFetcher;
    }

    public static String fetchString(final String userDataUrl, final Charset charset, final boolean shouldAttemptDecompression) throws IOException
    {
        return new String(fetchData(userDataUrl, shouldAttemptDecompression), charset);
    }

    private static byte[] fetchData(final String userDataUrl, final boolean shouldAttemptDecompression) throws IOException
    {
        final byte[] data;
        try
        {
            data = URLFetcherUtils.getURLFetcher().fetchData(userDataUrl);
        }
        catch (final FileNotFoundException e)
        {
            throw new FileNotFoundException("This program must be run within an EC2 instance started from Bamboo: " + e);
        }
        catch (final NoRouteToHostException e)
        {
            throw new NoRouteToHostException("Unable to access instance metadata. This program must be run within an EC2 instance: " + e);
        }
        return shouldAttemptDecompression ? CompressionUtils.decompress(data) : data;
    }
}
