/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.aws.s3;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.internal.ServiceUtils;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3Object;
import java.io.File;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.Nullable;

@Deprecated
public class BambooAmazonS3Client
extends AmazonS3Client {
    private static final Logger log = Logger.getLogger(BambooAmazonS3Client.class);

    public BambooAmazonS3Client(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration) {
        super(awsCredentials, clientConfiguration);
    }

    @Nullable
    public ObjectMetadata getObjectWithRetries(final GetObjectRequest getObjectRequest, File destinationFile) throws AmazonClientException, AmazonServiceException {
        if (destinationFile == null) {
            throw new NullPointerException("The destination file parameter must be specified when downloading an object directly to a file");
        }
        S3Object s3Object = this.retryableDownloadS3ObjectToFile(destinationFile, new ServiceUtils.RetryableS3DownloadTask(){

            public S3Object getS3ObjectStream() {
                return BambooAmazonS3Client.this.getObject(getObjectRequest);
            }

            public boolean needIntegrityCheck() {
                return getObjectRequest.getRange() == null;
            }
        });
        return s3Object != null ? s3Object.getObjectMetadata() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private S3Object retryableDownloadS3ObjectToFile(File file, ServiceUtils.RetryableS3DownloadTask retryableS3DownloadTask) {
        int retries = this.clientConfiguration.getMaxErrorRetry();
        S3Object s3Object;
        while ((s3Object = retryableS3DownloadTask.getS3ObjectStream()) != null) {
            try {
                ServiceUtils.downloadObjectToFile((S3Object)s3Object, (File)file, (boolean)retryableS3DownloadTask.needIntegrityCheck(), (boolean)false);
                S3Object s3Object2 = s3Object;
                return s3Object2;
            }
            catch (AmazonClientException ace) {
                if (retries-- == 0) {
                    throw ace;
                }
                log.info((Object)("Retry the download of object " + s3Object.getKey() + " (bucket " + s3Object.getBucketName() + ")"), (Throwable)ace);
                continue;
            }
            finally {
                BambooAmazonS3Client.abortQuietly(s3Object);
                continue;
            }
            break;
        }
        return null;
    }

    private static void abortQuietly(S3Object s3Object) {
        s3Object.getObjectContent().abort();
    }
}

