/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.osgi.javaconfig;

import com.atlassian.annotations.PublicApi;
import com.atlassian.plugin.osgi.external.ListableModuleDescriptorFactory;
import com.atlassian.plugins.osgi.javaconfig.ExportOptions;
import com.atlassian.plugins.osgi.javaconfig.ImportOptions;
import org.eclipse.gemini.blueprint.context.BundleContextAware;
import org.eclipse.gemini.blueprint.service.exporter.OsgiServiceRegistrationListener;
import org.eclipse.gemini.blueprint.service.exporter.support.DefaultInterfaceDetector;
import org.eclipse.gemini.blueprint.service.exporter.support.ExportContextClassLoaderEnum;
import org.eclipse.gemini.blueprint.service.exporter.support.InterfaceDetector;
import org.eclipse.gemini.blueprint.service.exporter.support.OsgiServiceFactoryBean;
import org.eclipse.gemini.blueprint.service.importer.support.OsgiServiceProxyFactoryBean;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceRegistration;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;

@PublicApi
public final class OsgiServices {
    public static <T> FactoryBean<T> factoryBeanForOsgiService(Class<T> serviceInterface) {
        return OsgiServices.factoryBeanForOsgiService(serviceInterface, ImportOptions.defaultOptions());
    }

    public static <T> FactoryBean<T> factoryBeanForOsgiService(Class<T> serviceInterface, ImportOptions options) {
        OsgiServiceProxyFactoryBean factoryBean = new OsgiServiceProxyFactoryBean();
        factoryBean.setAvailability(options.getAvailability());
        factoryBean.setBeanClassLoader(serviceInterface.getClassLoader());
        factoryBean.setFilter(options.getFilter());
        factoryBean.setInterfaces(new Class[]{serviceInterface});
        factoryBean.setTimeout(options.getTimeout().toMillis());
        return factoryBean;
    }

    public static <T> T importOsgiService(Class<T> serviceClass) {
        return OsgiServices.importOsgiService(serviceClass, ImportOptions.defaultOptions());
    }

    public static <T> T importOsgiService(Class<T> serviceClass, ImportOptions options) {
        FactoryBean<T> factoryBean = OsgiServices.factoryBeanForOsgiService(serviceClass, options);
        try {
            if (factoryBean instanceof BundleContextAware) {
                BundleContext bundleContext = FrameworkUtil.getBundle(OsgiServices.class).getBundleContext();
                ((BundleContextAware)factoryBean).setBundleContext(bundleContext);
            }
            if (factoryBean instanceof InitializingBean) {
                ((InitializingBean)factoryBean).afterPropertiesSet();
            }
            return (T)factoryBean.getObject();
        }
        catch (Exception e) {
            throw new BeanInitializationException(e.getMessage(), (Throwable)e);
        }
    }

    public static FactoryBean<ServiceRegistration> exportAsModuleType(ListableModuleDescriptorFactory moduleDescriptorFactory) {
        return OsgiServices.exportOsgiService(moduleDescriptorFactory, ExportOptions.as(ListableModuleDescriptorFactory.class, new Class[0]));
    }

    public static FactoryBean<ServiceRegistration> exportOsgiService(Object bean, ExportOptions options) {
        OsgiServiceFactoryBean exporter = new OsgiServiceFactoryBean();
        exporter.setInterfaceDetector((InterfaceDetector)DefaultInterfaceDetector.DISABLED);
        exporter.setBeanClassLoader(bean.getClass().getClassLoader());
        exporter.setExportContextClassLoader(ExportContextClassLoaderEnum.UNMANAGED);
        exporter.setInterfaces((Class[])options.getInterfaces());
        exporter.setServiceProperties(options.getProperties());
        exporter.setTarget(bean);
        exporter.setListeners(new OsgiServiceRegistrationListener[0]);
        return exporter;
    }

    private OsgiServices() {
    }
}

