/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.datatype.joda.ser;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.ContextualSerializer;
import com.fasterxml.jackson.datatype.joda.ser.JacksonJodaFormat;
import com.fasterxml.jackson.datatype.joda.ser.JodaSerializerBase;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public abstract class JodaDateSerializerBase<T>
extends JodaSerializerBase<T>
implements ContextualSerializer {
    protected static final DateTimeFormatter DEFAULT_DATEONLY_FORMAT = ISODateTimeFormat.date().withZoneUTC();
    protected static final DateTimeFormatter DEFAULT_TIMEONLY_FORMAT = ISODateTimeFormat.time().withZoneUTC();
    protected static final DateTimeFormatter DEFAULT_LOCAL_DATETIME_FORMAT = ISODateTimeFormat.dateTime().withZoneUTC();
    protected final JacksonJodaFormat _format;

    protected JodaDateSerializerBase(Class<T> type, JacksonJodaFormat format) {
        super(type);
        this._format = format;
    }

    public abstract JodaDateSerializerBase<T> withFormat(JacksonJodaFormat var1);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider prov, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value ann;
        if (property != null && (ann = prov.getAnnotationIntrospector().findFormat(property.getMember())) != null) {
            JacksonJodaFormat format = this._format;
            Boolean useTimestamp = ann.getShape().isNumeric() ? Boolean.TRUE : (ann.getShape() == JsonFormat.Shape.STRING ? Boolean.FALSE : null);
            if (useTimestamp != null) {
                format = format.withUseTimestamp(useTimestamp);
            }
            format = format.withFormat(ann.getPattern().trim());
            format = format.withLocale(ann.getLocale());
            if ((format = format.withTimeZone(ann.getTimeZone())) != this._format) {
                return this.withFormat(format);
            }
        }
        return this;
    }

    protected boolean _useTimestamp(SerializerProvider provider) {
        return this._format.useTimestamp(provider);
    }
}

