package com.atlassian.applinks.internal.status.error;

import com.atlassian.sal.api.net.Response;
import com.google.common.base.Splitter;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import static com.google.common.collect.Iterables.getFirst;


/**
 * @see ApplinkErrorType#UNEXPECTED_RESPONSE
 * @since 5.0
 */
public class UnexpectedResponseError extends AbstractResponseApplinkError {
    public UnexpectedResponseError(@Nonnull Response response) {
        super(response);
    }

    @Nonnull
    @Override
    public ApplinkErrorType getType() {
        return ApplinkErrorType.UNEXPECTED_RESPONSE;
    }

    @Nullable
    @Override
    public String getDetails() {
        // get first line of the body if possible
        String body = getBody();
        return body != null ?
                getFirst(Splitter.on(System.lineSeparator()).limit(2).split(body), null) :
                null;
    }
}
